/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.testutils.TestingJobResultStore;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public interface JobResultStoreContractTest {
    public static final JobResultEntry DUMMY_JOB_RESULT_ENTRY = new JobResultEntry(TestingJobResultStore.DUMMY_JOB_RESULT);

    public JobResultStore createJobResultStore() throws IOException;

    @Test
    default public void testStoreJobResultsWithDuplicateIDsThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        JobResultEntry otherEntryWithDuplicateId = new JobResultEntry(TestingJobResultStore.createSuccessfulJobResult(DUMMY_JOB_RESULT_ENTRY.getJobId()));
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.createDirtyResultAsync(otherEntryWithDuplicateId).join()).isInstanceOf(CompletionException.class)).hasCauseInstanceOf(IllegalStateException.class);
    }

    @Test
    default public void testStoreDirtyEntryForAlreadyCleanedJobResultThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join();
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join()).isInstanceOf(CompletionException.class)).hasCauseInstanceOf(IllegalStateException.class);
    }

    @Test
    default public void testCleaningDuplicateEntryThrowsNoException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join();
        Assertions.assertThatNoException().isThrownBy(() -> jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join());
    }

    @Test
    default public void testCleaningNonExistentEntryThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join()).hasCauseInstanceOf(NoSuchElementException.class);
    }

    @Test
    default public void testHasJobResultEntryWithDirtyEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasDirtyJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isTrue();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasCleanJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isTrue();
    }

    @Test
    default public void testHasJobResultEntryWithCleanEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasDirtyJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasCleanJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isTrue();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasJobResultEntryAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join())).isTrue();
    }

    @Test
    default public void testHasJobResultEntryWithEmptyStore() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        JobID jobId = new JobID();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasDirtyJobResultEntryAsync(jobId).join())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasCleanJobResultEntryAsync(jobId).join())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)jobResultStore.hasJobResultEntryAsync(jobId).join())).isFalse();
    }

    @Test
    default public void testGetDirtyResultsWithNoEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        Assertions.assertThat((Collection)jobResultStore.getDirtyResults()).isEmpty();
    }

    @Test
    default public void testGetDirtyResultsWithDirtyEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        ((ObjectAssert)Assertions.assertThat(jobResultStore.getDirtyResults().stream().map(JobResult::getJobId).collect(Collectors.toList())).singleElement()).isEqualTo((Object)DUMMY_JOB_RESULT_ENTRY.getJobId());
    }

    @Test
    default public void testGetDirtyResultsWithDirtyAndCleanEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResultAsync(DUMMY_JOB_RESULT_ENTRY).join();
        jobResultStore.markResultAsCleanAsync(DUMMY_JOB_RESULT_ENTRY.getJobId()).join();
        JobResultEntry otherDirtyJobResultEntry = new JobResultEntry(TestingJobResultStore.createSuccessfulJobResult(new JobID()));
        jobResultStore.createDirtyResultAsync(otherDirtyJobResultEntry).join();
        ((ObjectAssert)Assertions.assertThat(jobResultStore.getDirtyResults().stream().map(JobResult::getJobId).collect(Collectors.toList())).singleElement()).isEqualTo((Object)otherDirtyJobResultEntry.getJobId());
    }
}

