/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hadoop;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.flink.runtime.hadoop.HadoopUserUtils;
import org.apache.flink.runtime.security.token.hadoop.TestHadoopDelegationTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class HadoopUserUtilsITCase {
    private static final long NOW = 100L;

    HadoopUserUtilsITCase() {
    }

    @Test
    public void isProxyUserShouldReturnFalseWhenNormalUser() {
        UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.SIMPLE);
        Assertions.assertFalse((boolean)HadoopUserUtils.isProxyUser((UserGroupInformation)userGroupInformation));
    }

    @Test
    public void isProxyUserShouldReturnTrueWhenProxyUser() {
        UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.PROXY);
        Assertions.assertTrue((boolean)HadoopUserUtils.isProxyUser((UserGroupInformation)userGroupInformation));
    }

    @Test
    public void hasUserKerberosAuthMethodShouldReturnFalseWhenNoSecurity() {
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::isSecurityEnabled).thenReturn((Object)false);
            Assertions.assertFalse((boolean)HadoopUserUtils.hasUserKerberosAuthMethod((UserGroupInformation)userGroupInformation));
        }
    }

    @Test
    public void hasUserKerberosAuthMethodShouldReturnFalseWithSecurityAndNoKerberos() {
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.SIMPLE);
            ugi.when(UserGroupInformation::isSecurityEnabled).thenReturn((Object)true);
            Assertions.assertFalse((boolean)HadoopUserUtils.hasUserKerberosAuthMethod((UserGroupInformation)userGroupInformation));
        }
    }

    @Test
    public void hasUserKerberosAuthMethodShouldReturnTrueWithSecurityAndKerberos() {
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
            ugi.when(UserGroupInformation::isSecurityEnabled).thenReturn((Object)true);
            Assertions.assertTrue((boolean)HadoopUserUtils.hasUserKerberosAuthMethod((UserGroupInformation)userGroupInformation));
        }
    }

    @Test
    public void getIssueDateShouldReturnIssueDateWithFutureToken() {
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = 101L;
        TestHadoopDelegationTokenIdentifier tokenIdentifier = new TestHadoopDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)issueDate, (long)HadoopUserUtils.getIssueDate((Clock)constantClock, (String)tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }

    @Test
    public void getIssueDateShouldReturnIssueDateWithPastToken() {
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = 99L;
        TestHadoopDelegationTokenIdentifier tokenIdentifier = new TestHadoopDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)issueDate, (long)HadoopUserUtils.getIssueDate((Clock)constantClock, (String)tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }

    @Test
    public void getIssueDateShouldReturnNowWithInvalidToken() {
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = -1L;
        TestHadoopDelegationTokenIdentifier tokenIdentifier = new TestHadoopDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)100L, (long)HadoopUserUtils.getIssueDate((Clock)constantClock, (String)tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }
}

