/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.cluster.ClusterConfigHandler;
import org.apache.flink.runtime.rest.handler.cluster.ClusterOverviewHandler;
import org.apache.flink.runtime.rest.handler.cluster.DashboardConfigHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerCustomLogHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerEnvironmentHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerLogFileHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerLogListHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerProfilingFileHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerProfilingHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerProfilingListHandler;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerThreadDumpHandler;
import org.apache.flink.runtime.rest.handler.cluster.ShutdownHandler;
import org.apache.flink.runtime.rest.handler.dataset.ClusterDataSetDeleteHandlers;
import org.apache.flink.runtime.rest.handler.dataset.ClusterDataSetListHandler;
import org.apache.flink.runtime.rest.handler.job.GeneratedLogUrlHandler;
import org.apache.flink.runtime.rest.handler.job.JobAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.JobCancellationHandler;
import org.apache.flink.runtime.rest.handler.job.JobClientHeartbeatHandler;
import org.apache.flink.runtime.rest.handler.job.JobConfigHandler;
import org.apache.flink.runtime.rest.handler.job.JobDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.job.JobExecutionResultHandler;
import org.apache.flink.runtime.rest.handler.job.JobIdsHandler;
import org.apache.flink.runtime.rest.handler.job.JobManagerJobConfigurationHandler;
import org.apache.flink.runtime.rest.handler.job.JobManagerJobEnvironmentHandler;
import org.apache.flink.runtime.rest.handler.job.JobPlanHandler;
import org.apache.flink.runtime.rest.handler.job.JobResourceRequirementsHandler;
import org.apache.flink.runtime.rest.handler.job.JobResourceRequirementsUpdateHandler;
import org.apache.flink.runtime.rest.handler.job.JobStatusHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexBackPressureHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexFlameGraphHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexTaskManagersHandler;
import org.apache.flink.runtime.rest.handler.job.JobsOverviewHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskCurrentAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtasksAllAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.SubtasksTimesHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointConfigHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointHandlers;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointingStatisticsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.TaskCheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.coordination.ClientCoordinationHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingJobsMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingSubtasksMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingTaskManagersMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobManagerMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobManagerOperatorMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobVertexMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.JobVertexWatermarksHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.SubtaskMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.TaskManagerMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingHandlers;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointDisposalHandlers;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointHandlers;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.rest.handler.legacy.files.WebContentHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerCustomLogHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerDetailsHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerLogFileHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerLogListHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerProfilingFileHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerProfilingHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerProfilingListHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerStdoutFileHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerThreadDumpHandler;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagersHandler;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfoHeaders;
import org.apache.flink.runtime.rest.messages.ClusterOverviewHeaders;
import org.apache.flink.runtime.rest.messages.DashboardConfigurationHeaders;
import org.apache.flink.runtime.rest.messages.JobAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobCancellationHeaders;
import org.apache.flink.runtime.rest.messages.JobClientHeartbeatHeaders;
import org.apache.flink.runtime.rest.messages.JobConfigHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobIdsWithStatusesOverviewHeaders;
import org.apache.flink.runtime.rest.messages.JobManagerEnvironmentHeaders;
import org.apache.flink.runtime.rest.messages.JobManagerLogUrlHeaders;
import org.apache.flink.runtime.rest.messages.JobPlanHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersHeaders;
import org.apache.flink.runtime.rest.messages.JobsOverviewHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksAllAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksTimesHeaders;
import org.apache.flink.runtime.rest.messages.TaskManagerLogUrlHeaders;
import org.apache.flink.runtime.rest.messages.TerminationModeQueryParameter;
import org.apache.flink.runtime.rest.messages.YarnCancelJobTerminationHeaders;
import org.apache.flink.runtime.rest.messages.YarnStopJobTerminationHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointConfigHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatisticDetailsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerCustomLogHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerLogFileHeader;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerLogListHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerProfilingFileHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerProfilingHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerProfilingListHeaders;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerStdoutFileHeader;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerThreadDumpHeaders;
import org.apache.flink.runtime.rest.messages.cluster.ShutdownHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.JobManagerJobConfigurationHeaders;
import org.apache.flink.runtime.rest.messages.job.JobManagerJobEnvironmentHeaders;
import org.apache.flink.runtime.rest.messages.job.JobStatusInfoHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskCurrentAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.coordination.ClientCoordinationHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerCustomLogHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerLogFileHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerLogsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerProfilingFileHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerProfilingHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerProfilingListHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerStdoutFileHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerThreadDumpHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersHeaders;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoRequestCoordinator;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoTracker;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoTrackerBuilder;
import org.apache.flink.shaded.guava32.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava32.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;

public class WebMonitorEndpoint<T extends RestfulGateway>
extends RestServerEndpoint
implements LeaderContender,
JsonArchivist {
    protected final GatewayRetriever<? extends T> leaderRetriever;
    protected final Configuration clusterConfiguration;
    protected final RestHandlerConfiguration restConfiguration;
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever;
    private final TransientBlobService transientBlobService;
    protected final ScheduledExecutorService executor;
    private final ExecutionGraphCache executionGraphCache;
    private final CheckpointStatsCache checkpointStatsCache;
    private final Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache;
    private final MetricFetcher metricFetcher;
    private final LeaderElection leaderElection;
    private final FatalErrorHandler fatalErrorHandler;
    private boolean hasWebUI = false;
    private final Collection<JsonArchivist> archivingHandlers = new ArrayList<JsonArchivist>(16);
    @Nullable
    private ScheduledFuture<?> executionGraphCleanupTask;

    public WebMonitorEndpoint(GatewayRetriever<? extends T> leaderRetriever, Configuration clusterConfiguration, RestHandlerConfiguration restConfiguration, GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever, TransientBlobService transientBlobService, ScheduledExecutorService executor, MetricFetcher metricFetcher, LeaderElection leaderElection, ExecutionGraphCache executionGraphCache, FatalErrorHandler fatalErrorHandler) throws IOException, ConfigurationException {
        super(clusterConfiguration);
        this.leaderRetriever = (GatewayRetriever)Preconditions.checkNotNull(leaderRetriever);
        this.clusterConfiguration = (Configuration)Preconditions.checkNotNull((Object)clusterConfiguration);
        this.restConfiguration = (RestHandlerConfiguration)Preconditions.checkNotNull((Object)restConfiguration);
        this.resourceManagerRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerRetriever);
        this.transientBlobService = (TransientBlobService)Preconditions.checkNotNull((Object)transientBlobService);
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        this.executionGraphCache = executionGraphCache;
        this.checkpointStatsCache = new CheckpointStatsCache(restConfiguration.getCheckpointHistorySize());
        this.checkpointStatsSnapshotCache = CacheBuilder.newBuilder().maximumSize((long)restConfiguration.getCheckpointCacheSize()).expireAfterWrite(restConfiguration.getCheckpointCacheExpireAfterWrite()).build();
        this.metricFetcher = metricFetcher;
        this.leaderElection = (LeaderElection)Preconditions.checkNotNull((Object)leaderElection);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
    }

    private VertexThreadInfoTracker initializeThreadInfoTracker(ScheduledExecutorService executor) {
        Duration askTimeout = (Duration)this.clusterConfiguration.get(RpcOptions.ASK_TIMEOUT_DURATION);
        Duration flameGraphCleanUpInterval = (Duration)this.clusterConfiguration.get(RestOptions.FLAMEGRAPH_CLEANUP_INTERVAL);
        ThreadInfoRequestCoordinator threadInfoRequestCoordinator = new ThreadInfoRequestCoordinator(executor, askTimeout);
        return VertexThreadInfoTrackerBuilder.newBuilder(this.resourceManagerRetriever, executor, this.restConfiguration.getTimeout()).setCoordinator(threadInfoRequestCoordinator).setCleanUpInterval(flameGraphCleanUpInterval).setNumSamples((Integer)this.clusterConfiguration.get(RestOptions.FLAMEGRAPH_NUM_SAMPLES)).setStatsRefreshInterval((Duration)this.clusterConfiguration.get(RestOptions.FLAMEGRAPH_REFRESH_INTERVAL)).setDelayBetweenSamples((Duration)this.clusterConfiguration.get(RestOptions.FLAMEGRAPH_DELAY)).setMaxThreadInfoDepth((Integer)this.clusterConfiguration.get(RestOptions.FLAMEGRAPH_STACK_TRACE_DEPTH)).build();
    }

    @Override
    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> localAddressFuture) {
        Optional<StaticFileServerHandler<Object>> optWebContent;
        ClusterDataSetDeleteHandlers clusterDataSetDeleteHandlers;
        SavepointDisposalHandlers savepointDisposalHandlers;
        RescalingHandlers rescalingHandlers;
        SavepointHandlers savepointHandlers;
        ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>(30);
        Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> webSubmissionHandlers = this.initializeWebSubmissionHandlers(localAddressFuture);
        handlers.addAll(webSubmissionHandlers);
        boolean hasWebSubmissionHandlers = !webSubmissionHandlers.isEmpty();
        Duration asyncOperationStoreDuration = (Duration)this.clusterConfiguration.get(RestOptions.ASYNC_OPERATION_STORE_DURATION);
        Duration timeout = this.restConfiguration.getTimeout();
        ClusterOverviewHandler clusterOverviewHandler = new ClusterOverviewHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, ClusterOverviewHeaders.getInstance());
        DashboardConfigHandler dashboardConfigHandler = new DashboardConfigHandler(this.leaderRetriever, timeout, this.responseHeaders, DashboardConfigurationHeaders.getInstance(), this.restConfiguration.getRefreshInterval(), hasWebSubmissionHandlers, this.restConfiguration.isWebCancelEnabled(), this.restConfiguration.isWebRescaleEnabled());
        JobIdsHandler jobIdsHandler = new JobIdsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobIdsWithStatusesOverviewHeaders.getInstance());
        JobStatusHandler jobStatusHandler = new JobStatusHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobStatusInfoHeaders.getInstance());
        JobsOverviewHandler jobsOverviewHandler = new JobsOverviewHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobsOverviewHeaders.getInstance());
        ClusterConfigHandler clusterConfigurationHandler = new ClusterConfigHandler(this.leaderRetriever, timeout, this.responseHeaders, ClusterConfigurationInfoHeaders.getInstance(), this.clusterConfiguration);
        JobManagerEnvironmentHandler jobManagerEnvironmentHandler = new JobManagerEnvironmentHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobManagerEnvironmentHeaders.getInstance());
        JobManagerJobEnvironmentHandler jobManagerJobEnvironmentHandler = new JobManagerJobEnvironmentHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobManagerJobEnvironmentHeaders.getInstance());
        JobConfigHandler jobConfigHandler = new JobConfigHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobConfigHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        JobManagerJobConfigurationHandler jobManagerJobConfigurationHandler = new JobManagerJobConfigurationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerJobConfigurationHeaders.getInstance(), this.clusterConfiguration);
        CheckpointConfigHandler checkpointConfigHandler = new CheckpointConfigHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointConfigHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        CheckpointingStatisticsHandler checkpointStatisticsHandler = new CheckpointingStatisticsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointingStatisticsHeaders.getInstance(), this.checkpointStatsSnapshotCache, (Executor)this.executor);
        CheckpointStatisticDetailsHandler checkpointStatisticDetailsHandler = new CheckpointStatisticDetailsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, CheckpointStatisticDetailsHeaders.getInstance(), (Executor)this.executor, this.checkpointStatsSnapshotCache, this.checkpointStatsCache);
        JobPlanHandler jobPlanHandler = new JobPlanHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobPlanHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        TaskCheckpointStatisticDetailsHandler taskCheckpointStatisticDetailsHandler = new TaskCheckpointStatisticDetailsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskCheckpointStatisticsHeaders.getInstance(), (Executor)this.executor, this.checkpointStatsSnapshotCache, this.checkpointStatsCache);
        JobExceptionsHandler jobExceptionsHandler = new JobExceptionsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobExceptionsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        JobVertexAccumulatorsHandler jobVertexAccumulatorsHandler = new JobVertexAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobVertexAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtasksAllAccumulatorsHandler subtasksAllAccumulatorsHandler = new SubtasksAllAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtasksAllAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        TaskManagersHandler taskManagersHandler = new TaskManagersHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagersHeaders.getInstance(), this.resourceManagerRetriever);
        TaskManagerDetailsHandler taskManagerDetailsHandler = new TaskManagerDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, TaskManagerDetailsHeaders.getInstance(), this.resourceManagerRetriever, this.metricFetcher);
        JobDetailsHandler jobDetailsHandler = new JobDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, JobDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        JobAccumulatorsHandler jobAccumulatorsHandler = new JobAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtasksTimesHandler subtasksTimesHandler = new SubtasksTimesHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtasksTimesHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        JobVertexMetricsHandler jobVertexMetricsHandler = new JobVertexMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        JobVertexWatermarksHandler jobVertexWatermarksHandler = new JobVertexWatermarksHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher, this.executionGraphCache, (Executor)this.executor);
        JobMetricsHandler jobMetricsHandler = new JobMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        SubtaskMetricsHandler subtaskMetricsHandler = new SubtaskMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        TaskManagerMetricsHandler taskManagerMetricsHandler = new TaskManagerMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        JobManagerOperatorMetricsHandler jobManagerOperatorMetricsHandler = new JobManagerOperatorMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        JobManagerMetricsHandler jobManagerMetricsHandler = new JobManagerMetricsHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.metricFetcher);
        AggregatingTaskManagersMetricsHandler aggregatingTaskManagersMetricsHandler = new AggregatingTaskManagersMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        AggregatingJobsMetricsHandler aggregatingJobsMetricsHandler = new AggregatingJobsMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        AggregatingSubtasksMetricsHandler aggregatingSubtasksMetricsHandler = new AggregatingSubtasksMetricsHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.metricFetcher);
        JobVertexTaskManagersHandler jobVertexTaskManagersHandler = new JobVertexTaskManagersHandler(this.leaderRetriever, timeout, this.responseHeaders, JobVertexTaskManagersHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        JobExecutionResultHandler jobExecutionResultHandler = new JobExecutionResultHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        String defaultSavepointDir = (String)this.clusterConfiguration.get(CheckpointingOptions.SAVEPOINT_DIRECTORY);
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers(defaultSavepointDir);
        Objects.requireNonNull(savepointHandlers2);
        SavepointHandlers.StopWithSavepointHandler stopWithSavepointHandler = new SavepointHandlers.StopWithSavepointHandler(savepointHandlers2, this.leaderRetriever, timeout, this.responseHeaders);
        SavepointHandlers savepointHandlers3 = savepointHandlers;
        Objects.requireNonNull(savepointHandlers3);
        SavepointHandlers.SavepointTriggerHandler savepointTriggerHandler = new SavepointHandlers.SavepointTriggerHandler(savepointHandlers3, this.leaderRetriever, timeout, this.responseHeaders);
        SavepointHandlers.SavepointStatusHandler savepointStatusHandler = new SavepointHandlers.SavepointStatusHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        CheckpointHandlers.CheckpointTriggerHandler checkpointTriggerHandler = new CheckpointHandlers.CheckpointTriggerHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        CheckpointHandlers.CheckpointStatusHandler checkpointStatusHandler = new CheckpointHandlers.CheckpointStatusHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        SubtaskExecutionAttemptDetailsHandler subtaskExecutionAttemptDetailsHandler = new SubtaskExecutionAttemptDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, SubtaskExecutionAttemptDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        SubtaskExecutionAttemptAccumulatorsHandler subtaskExecutionAttemptAccumulatorsHandler = new SubtaskExecutionAttemptAccumulatorsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, SubtaskExecutionAttemptAccumulatorsHeaders.getInstance(), this.executionGraphCache, (Executor)this.executor);
        SubtaskCurrentAttemptDetailsHandler subtaskCurrentAttemptDetailsHandler = new SubtaskCurrentAttemptDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, SubtaskCurrentAttemptDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        RescalingHandlers rescalingHandlers2 = rescalingHandlers = new RescalingHandlers(asyncOperationStoreDuration);
        Objects.requireNonNull(rescalingHandlers2);
        RescalingHandlers.RescalingTriggerHandler rescalingTriggerHandler = new RescalingHandlers.RescalingTriggerHandler(rescalingHandlers2, this.leaderRetriever, timeout, this.responseHeaders);
        RescalingHandlers rescalingHandlers3 = rescalingHandlers;
        Objects.requireNonNull(rescalingHandlers3);
        RescalingHandlers.RescalingStatusHandler rescalingStatusHandler = new RescalingHandlers.RescalingStatusHandler(rescalingHandlers3, this.leaderRetriever, timeout, this.responseHeaders);
        JobVertexBackPressureHandler jobVertexBackPressureHandler = new JobVertexBackPressureHandler(this.leaderRetriever, timeout, this.responseHeaders, JobVertexBackPressureHeaders.getInstance(), this.metricFetcher);
        JobCancellationHandler jobCancelTerminationHandler = new JobCancellationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.CANCEL);
        JobCancellationHandler yarnJobCancelTerminationHandler = new JobCancellationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.CANCEL);
        JobCancellationHandler jobStopTerminationHandler = new JobCancellationHandler(this.leaderRetriever, timeout, this.responseHeaders, JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.STOP);
        JobVertexDetailsHandler jobVertexDetailsHandler = new JobVertexDetailsHandler(this.leaderRetriever, timeout, this.responseHeaders, JobVertexDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.metricFetcher);
        GeneratedLogUrlHandler jobManagerLogUrlHandler = new GeneratedLogUrlHandler((CompletableFuture<String>)localAddressFuture.thenApply(url -> url + "/#/job-manager/logs"));
        GeneratedLogUrlHandler taskManagerLogUrlHandler = new GeneratedLogUrlHandler((CompletableFuture<String>)localAddressFuture.thenApply(url -> url + "/#/task-manager/<tmid>/logs"));
        SavepointDisposalHandlers savepointDisposalHandlers2 = savepointDisposalHandlers = new SavepointDisposalHandlers(asyncOperationStoreDuration);
        Objects.requireNonNull(savepointDisposalHandlers2);
        SavepointDisposalHandlers.SavepointDisposalTriggerHandler savepointDisposalTriggerHandler = new SavepointDisposalHandlers.SavepointDisposalTriggerHandler(savepointDisposalHandlers2, this.leaderRetriever, timeout, this.responseHeaders);
        SavepointDisposalHandlers savepointDisposalHandlers3 = savepointDisposalHandlers;
        Objects.requireNonNull(savepointDisposalHandlers3);
        SavepointDisposalHandlers.SavepointDisposalStatusHandler savepointDisposalStatusHandler = new SavepointDisposalHandlers.SavepointDisposalStatusHandler(savepointDisposalHandlers3, this.leaderRetriever, timeout, this.responseHeaders);
        ClusterDataSetListHandler clusterDataSetListHandler = new ClusterDataSetListHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.resourceManagerRetriever);
        ClusterDataSetDeleteHandlers clusterDataSetDeleteHandlers2 = clusterDataSetDeleteHandlers = new ClusterDataSetDeleteHandlers(asyncOperationStoreDuration);
        Objects.requireNonNull(clusterDataSetDeleteHandlers2);
        ClusterDataSetDeleteHandlers.ClusterDataSetDeleteTriggerHandler clusterDataSetDeleteTriggerHandler = new ClusterDataSetDeleteHandlers.ClusterDataSetDeleteTriggerHandler(clusterDataSetDeleteHandlers2, this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.resourceManagerRetriever);
        ClusterDataSetDeleteHandlers clusterDataSetDeleteHandlers3 = clusterDataSetDeleteHandlers;
        Objects.requireNonNull(clusterDataSetDeleteHandlers3);
        ClusterDataSetDeleteHandlers.ClusterDataSetDeleteStatusHandler clusterDataSetDeleteStatusHandler = new ClusterDataSetDeleteHandlers.ClusterDataSetDeleteStatusHandler(clusterDataSetDeleteHandlers3, this.leaderRetriever, timeout, this.responseHeaders);
        ClientCoordinationHandler clientCoordinationHandler = new ClientCoordinationHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, ClientCoordinationHeaders.getInstance());
        ShutdownHandler shutdownHandler = new ShutdownHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, ShutdownHeaders.getInstance());
        JobClientHeartbeatHandler jobClientHeartbeatHandler = new JobClientHeartbeatHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobClientHeartbeatHeaders.getInstance());
        File webUiDir = this.restConfiguration.getWebUiDir();
        try {
            optWebContent = WebMonitorUtils.tryLoadWebContent(this.leaderRetriever, timeout, webUiDir);
        }
        catch (IOException e) {
            this.log.warn("Could not load web content handler.", (Throwable)e);
            optWebContent = Optional.empty();
        }
        handlers.add(Tuple2.of(clusterOverviewHandler.getMessageHeaders(), (Object)((Object)clusterOverviewHandler)));
        handlers.add(Tuple2.of(clusterConfigurationHandler.getMessageHeaders(), (Object)((Object)clusterConfigurationHandler)));
        handlers.add(Tuple2.of(jobManagerEnvironmentHandler.getMessageHeaders(), (Object)((Object)jobManagerEnvironmentHandler)));
        handlers.add(Tuple2.of(jobManagerJobEnvironmentHandler.getMessageHeaders(), (Object)jobManagerJobEnvironmentHandler));
        handlers.add(Tuple2.of(dashboardConfigHandler.getMessageHeaders(), (Object)((Object)dashboardConfigHandler)));
        handlers.add(Tuple2.of(jobIdsHandler.getMessageHeaders(), (Object)((Object)jobIdsHandler)));
        handlers.add(Tuple2.of(jobStatusHandler.getMessageHeaders(), (Object)((Object)jobStatusHandler)));
        handlers.add(Tuple2.of(jobsOverviewHandler.getMessageHeaders(), (Object)jobsOverviewHandler));
        handlers.add(Tuple2.of(jobConfigHandler.getMessageHeaders(), (Object)jobConfigHandler));
        handlers.add(Tuple2.of(checkpointConfigHandler.getMessageHeaders(), (Object)checkpointConfigHandler));
        handlers.add(Tuple2.of(checkpointStatisticsHandler.getMessageHeaders(), (Object)checkpointStatisticsHandler));
        handlers.add(Tuple2.of(checkpointStatisticDetailsHandler.getMessageHeaders(), (Object)checkpointStatisticDetailsHandler));
        handlers.add(Tuple2.of(jobPlanHandler.getMessageHeaders(), (Object)jobPlanHandler));
        handlers.add(Tuple2.of(taskCheckpointStatisticDetailsHandler.getMessageHeaders(), (Object)taskCheckpointStatisticDetailsHandler));
        handlers.add(Tuple2.of(jobExceptionsHandler.getMessageHeaders(), (Object)jobExceptionsHandler));
        handlers.add(Tuple2.of(jobVertexAccumulatorsHandler.getMessageHeaders(), (Object)((Object)jobVertexAccumulatorsHandler)));
        handlers.add(Tuple2.of(subtasksAllAccumulatorsHandler.getMessageHeaders(), (Object)((Object)subtasksAllAccumulatorsHandler)));
        handlers.add(Tuple2.of(jobDetailsHandler.getMessageHeaders(), (Object)jobDetailsHandler));
        handlers.add(Tuple2.of(jobAccumulatorsHandler.getMessageHeaders(), (Object)jobAccumulatorsHandler));
        handlers.add(Tuple2.of(taskManagersHandler.getMessageHeaders(), (Object)((Object)taskManagersHandler)));
        handlers.add(Tuple2.of(taskManagerDetailsHandler.getMessageHeaders(), (Object)((Object)taskManagerDetailsHandler)));
        handlers.add(Tuple2.of(subtasksTimesHandler.getMessageHeaders(), (Object)subtasksTimesHandler));
        handlers.add(Tuple2.of(jobVertexMetricsHandler.getMessageHeaders(), (Object)((Object)jobVertexMetricsHandler)));
        handlers.add(Tuple2.of(jobVertexWatermarksHandler.getMessageHeaders(), (Object)((Object)jobVertexWatermarksHandler)));
        handlers.add(Tuple2.of(jobMetricsHandler.getMessageHeaders(), (Object)((Object)jobMetricsHandler)));
        handlers.add(Tuple2.of(subtaskMetricsHandler.getMessageHeaders(), (Object)((Object)subtaskMetricsHandler)));
        handlers.add(Tuple2.of(taskManagerMetricsHandler.getMessageHeaders(), (Object)((Object)taskManagerMetricsHandler)));
        handlers.add(Tuple2.of(jobManagerMetricsHandler.getMessageHeaders(), (Object)((Object)jobManagerMetricsHandler)));
        handlers.add(Tuple2.of(jobManagerOperatorMetricsHandler.getMessageHeaders(), (Object)((Object)jobManagerOperatorMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingTaskManagersMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingTaskManagersMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingJobsMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingJobsMetricsHandler)));
        handlers.add(Tuple2.of(aggregatingSubtasksMetricsHandler.getMessageHeaders(), (Object)((Object)aggregatingSubtasksMetricsHandler)));
        handlers.add(Tuple2.of(jobExecutionResultHandler.getMessageHeaders(), (Object)((Object)jobExecutionResultHandler)));
        handlers.add(Tuple2.of(savepointTriggerHandler.getMessageHeaders(), (Object)((Object)savepointTriggerHandler)));
        handlers.add(Tuple2.of(stopWithSavepointHandler.getMessageHeaders(), (Object)((Object)stopWithSavepointHandler)));
        handlers.add(Tuple2.of(savepointStatusHandler.getMessageHeaders(), (Object)((Object)savepointStatusHandler)));
        handlers.add(Tuple2.of(checkpointTriggerHandler.getMessageHeaders(), (Object)((Object)checkpointTriggerHandler)));
        handlers.add(Tuple2.of(checkpointStatusHandler.getMessageHeaders(), (Object)((Object)checkpointStatusHandler)));
        handlers.add(Tuple2.of(subtaskExecutionAttemptDetailsHandler.getMessageHeaders(), (Object)subtaskExecutionAttemptDetailsHandler));
        handlers.add(Tuple2.of(subtaskExecutionAttemptAccumulatorsHandler.getMessageHeaders(), (Object)subtaskExecutionAttemptAccumulatorsHandler));
        handlers.add(Tuple2.of(subtaskCurrentAttemptDetailsHandler.getMessageHeaders(), (Object)((Object)subtaskCurrentAttemptDetailsHandler)));
        handlers.add(Tuple2.of(jobVertexTaskManagersHandler.getMessageHeaders(), (Object)jobVertexTaskManagersHandler));
        handlers.add(Tuple2.of(jobVertexBackPressureHandler.getMessageHeaders(), (Object)((Object)jobVertexBackPressureHandler)));
        handlers.add(Tuple2.of(jobManagerJobConfigurationHandler.getMessageHeaders(), (Object)jobManagerJobConfigurationHandler));
        handlers.add(Tuple2.of((Object)JobManagerLogUrlHeaders.getInstance(), (Object)((Object)jobManagerLogUrlHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerLogUrlHeaders.getInstance(), (Object)((Object)taskManagerLogUrlHandler)));
        JobVertexFlameGraphHandler jobVertexFlameGraphHandler = (Boolean)this.clusterConfiguration.get(RestOptions.ENABLE_FLAMEGRAPH) != false ? new JobVertexFlameGraphHandler(this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, this.executionGraphCache, this.executor, this.initializeThreadInfoTracker(this.executor)) : JobVertexFlameGraphHandler.disabledHandler(this.leaderRetriever, timeout, this.responseHeaders);
        handlers.add(Tuple2.of(jobVertexFlameGraphHandler.getMessageHeaders(), jobVertexFlameGraphHandler));
        handlers.add(Tuple2.of(jobCancelTerminationHandler.getMessageHeaders(), (Object)((Object)jobCancelTerminationHandler)));
        handlers.add(Tuple2.of(jobVertexDetailsHandler.getMessageHeaders(), (Object)jobVertexDetailsHandler));
        handlers.add(Tuple2.of(rescalingTriggerHandler.getMessageHeaders(), (Object)((Object)rescalingTriggerHandler)));
        handlers.add(Tuple2.of(rescalingStatusHandler.getMessageHeaders(), (Object)((Object)rescalingStatusHandler)));
        handlers.add(Tuple2.of(savepointDisposalTriggerHandler.getMessageHeaders(), (Object)((Object)savepointDisposalTriggerHandler)));
        handlers.add(Tuple2.of(savepointDisposalStatusHandler.getMessageHeaders(), (Object)((Object)savepointDisposalStatusHandler)));
        handlers.add(Tuple2.of(clusterDataSetListHandler.getMessageHeaders(), (Object)((Object)clusterDataSetListHandler)));
        handlers.add(Tuple2.of(clusterDataSetDeleteTriggerHandler.getMessageHeaders(), (Object)((Object)clusterDataSetDeleteTriggerHandler)));
        handlers.add(Tuple2.of(clusterDataSetDeleteStatusHandler.getMessageHeaders(), (Object)((Object)clusterDataSetDeleteStatusHandler)));
        handlers.add(Tuple2.of(clientCoordinationHandler.getMessageHeaders(), (Object)((Object)clientCoordinationHandler)));
        handlers.add(Tuple2.of((Object)YarnCancelJobTerminationHeaders.getInstance(), (Object)((Object)yarnJobCancelTerminationHandler)));
        handlers.add(Tuple2.of((Object)YarnStopJobTerminationHeaders.getInstance(), (Object)((Object)jobStopTerminationHandler)));
        handlers.add(Tuple2.of(shutdownHandler.getMessageHeaders(), (Object)((Object)shutdownHandler)));
        handlers.add(Tuple2.of(jobClientHeartbeatHandler.getMessageHeaders(), (Object)((Object)jobClientHeartbeatHandler)));
        optWebContent.ifPresent(webContent -> {
            handlers.add(Tuple2.of((Object)WebContentHandlerSpecification.getInstance(), (Object)webContent));
            this.hasWebUI = true;
        });
        WebMonitorUtils.LogFileLocation logFileLocation = WebMonitorUtils.LogFileLocation.find(this.clusterConfiguration);
        JobManagerLogFileHandler jobManagerLogFileHandler = new JobManagerLogFileHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerLogFileHeader.getInstance(), logFileLocation.logFile);
        JobManagerLogFileHandler jobManagerStdoutFileHandler = new JobManagerLogFileHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerStdoutFileHeader.getInstance(), logFileLocation.stdOutFile);
        JobManagerCustomLogHandler jobManagerCustomLogHandler = new JobManagerCustomLogHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerCustomLogHeaders.getInstance(), logFileLocation.logDir);
        JobManagerLogListHandler jobManagerLogListHandler = new JobManagerLogListHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerLogListHeaders.getInstance(), logFileLocation.logDir);
        JobManagerThreadDumpHandler jobManagerThreadDumpHandler = new JobManagerThreadDumpHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, JobManagerThreadDumpHeaders.getInstance());
        handlers.add(Tuple2.of((Object)JobManagerLogFileHeader.getInstance(), (Object)((Object)jobManagerLogFileHandler)));
        handlers.add(Tuple2.of((Object)JobManagerStdoutFileHeader.getInstance(), (Object)((Object)jobManagerStdoutFileHandler)));
        handlers.add(Tuple2.of((Object)JobManagerCustomLogHeaders.getInstance(), (Object)((Object)jobManagerCustomLogHandler)));
        handlers.add(Tuple2.of((Object)JobManagerLogListHeaders.getInstance(), (Object)((Object)jobManagerLogListHandler)));
        handlers.add(Tuple2.of((Object)JobManagerThreadDumpHeaders.getInstance(), (Object)((Object)jobManagerThreadDumpHandler)));
        Duration cacheEntryDuration = Duration.ofMillis(this.restConfiguration.getRefreshInterval());
        if (((Boolean)this.clusterConfiguration.get(RestOptions.ENABLE_PROFILER)).booleanValue()) {
            JobManagerProfilingHandler jobManagerProfilingHandler = new JobManagerProfilingHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerProfilingHeaders.getInstance(), this.clusterConfiguration);
            JobManagerProfilingListHandler jobManagerProfilingListHandler = new JobManagerProfilingListHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerProfilingListHeaders.getInstance(), this.clusterConfiguration);
            JobManagerProfilingFileHandler jobManagerProfilingFileHandler = new JobManagerProfilingFileHandler(this.leaderRetriever, timeout, this.responseHeaders, JobManagerProfilingFileHeaders.getInstance(), this.clusterConfiguration);
            TaskManagerProfilingHandler taskManagerProfilingHandler = new TaskManagerProfilingHandler(this.leaderRetriever, timeout, this.responseHeaders, TaskManagerProfilingHeaders.getInstance(), this.resourceManagerRetriever, this.clusterConfiguration);
            TaskManagerProfilingListHandler taskManagerProfilingListHandler = new TaskManagerProfilingListHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerProfilingListHeaders.getInstance(), this.resourceManagerRetriever);
            TaskManagerProfilingFileHandler taskManagerProfilingFileHandler = new TaskManagerProfilingFileHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerProfilingFileHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
            handlers.add(Tuple2.of((Object)JobManagerProfilingHeaders.getInstance(), (Object)((Object)jobManagerProfilingHandler)));
            handlers.add(Tuple2.of((Object)JobManagerProfilingListHeaders.getInstance(), (Object)((Object)jobManagerProfilingListHandler)));
            handlers.add(Tuple2.of((Object)JobManagerProfilingFileHeaders.getInstance(), (Object)((Object)jobManagerProfilingFileHandler)));
            handlers.add(Tuple2.of((Object)TaskManagerProfilingHeaders.getInstance(), (Object)((Object)taskManagerProfilingHandler)));
            handlers.add(Tuple2.of((Object)TaskManagerProfilingListHeaders.getInstance(), (Object)((Object)taskManagerProfilingListHandler)));
            handlers.add(Tuple2.of((Object)TaskManagerProfilingFileHeaders.getInstance(), (Object)((Object)taskManagerProfilingFileHandler)));
        }
        TaskManagerLogFileHandler taskManagerLogFileHandler = new TaskManagerLogFileHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerLogFileHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
        TaskManagerStdoutFileHandler taskManagerStdoutFileHandler = new TaskManagerStdoutFileHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerStdoutFileHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
        TaskManagerCustomLogHandler taskManagerCustomLogHandler = new TaskManagerCustomLogHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerCustomLogHeaders.getInstance(), this.resourceManagerRetriever, this.transientBlobService, cacheEntryDuration);
        TaskManagerLogListHandler taskManagerLogListHandler = new TaskManagerLogListHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerLogsHeaders.getInstance(), this.resourceManagerRetriever);
        TaskManagerThreadDumpHandler taskManagerThreadDumpFileHandler = new TaskManagerThreadDumpHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders, TaskManagerThreadDumpHeaders.getInstance(), this.resourceManagerRetriever);
        handlers.add(Tuple2.of((Object)TaskManagerLogFileHeaders.getInstance(), (Object)((Object)taskManagerLogFileHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerStdoutFileHeaders.getInstance(), (Object)((Object)taskManagerStdoutFileHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerCustomLogHeaders.getInstance(), (Object)((Object)taskManagerCustomLogHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerLogsHeaders.getInstance(), (Object)((Object)taskManagerLogListHandler)));
        handlers.add(Tuple2.of((Object)TaskManagerThreadDumpHeaders.getInstance(), (Object)((Object)taskManagerThreadDumpFileHandler)));
        JobResourceRequirementsHandler jobResourceRequirementsHandler = new JobResourceRequirementsHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        JobResourceRequirementsUpdateHandler jobResourceRequirementsUpdateHandler = new JobResourceRequirementsUpdateHandler((GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, (Map<String, String>)this.responseHeaders);
        handlers.add(Tuple2.of(jobResourceRequirementsHandler.getMessageHeaders(), (Object)((Object)jobResourceRequirementsHandler)));
        handlers.add(Tuple2.of(jobResourceRequirementsUpdateHandler.getMessageHeaders(), (Object)((Object)jobResourceRequirementsUpdateHandler)));
        handlers.stream().map(tuple -> (ChannelInboundHandler)tuple.f1).filter(handler -> handler instanceof JsonArchivist).forEachOrdered(handler -> this.archivingHandlers.add((JsonArchivist)handler));
        return handlers;
    }

    protected Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeWebSubmissionHandlers(CompletableFuture<String> localAddressFuture) {
        return Collections.emptyList();
    }

    @Override
    public void startInternal() throws Exception {
        this.leaderElection.startLeaderElection(this);
        this.startExecutionGraphCacheCleanupTask();
        if (this.hasWebUI) {
            this.log.info("Web frontend listening at {}.", (Object)this.getRestBaseUrl());
        }
    }

    private void startExecutionGraphCacheCleanupTask() {
        long cleanupInterval = 2L * this.restConfiguration.getRefreshInterval();
        this.executionGraphCleanupTask = this.executor.scheduleWithFixedDelay(this.executionGraphCache::cleanup, cleanupInterval, cleanupInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    protected CompletableFuture<Void> shutDownInternal() {
        if (this.executionGraphCleanupTask != null) {
            this.executionGraphCleanupTask.cancel(false);
        }
        this.executionGraphCache.close();
        CompletableFuture shutdownFuture = FutureUtils.runAfterwards(super.shutDownInternal(), () -> ExecutorUtils.gracefulShutdown((long)10L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executor}));
        File webUiDir = this.restConfiguration.getWebUiDir();
        return FutureUtils.runAfterwardsAsync((CompletableFuture)shutdownFuture, () -> {
            Exception exception = null;
            try {
                this.log.info("Removing cache directory {}", (Object)webUiDir);
                FileUtils.deleteDirectory((File)webUiDir);
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                if (this.leaderElection != null) {
                    this.leaderElection.close();
                }
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                throw exception;
            }
        });
    }

    @Override
    public void grantLeadership(UUID leaderSessionID) {
        this.log.info("{} was granted leadership with leaderSessionID={}", (Object)this.getRestBaseUrl(), (Object)leaderSessionID);
        this.leaderElection.confirmLeadershipAsync(leaderSessionID, this.getRestBaseUrl());
    }

    @Override
    public void revokeLeadership() {
        this.log.info("{} lost leadership", (Object)this.getRestBaseUrl());
    }

    @Override
    public void handleError(Exception exception) {
        this.fatalErrorHandler.onFatalError((Throwable)exception);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(ExecutionGraphInfo executionGraphInfo) throws IOException {
        ArrayList<ArchivedJson> archivedJson = new ArrayList<ArchivedJson>(this.archivingHandlers.size());
        for (JsonArchivist archivist : this.archivingHandlers) {
            Collection<ArchivedJson> subArchive = archivist.archiveJsonWithPath(executionGraphInfo);
            archivedJson.addAll(subArchive);
        }
        return archivedJson;
    }

    public static ScheduledExecutorService createExecutorService(int numThreads, int threadPriority, String componentName) {
        if (threadPriority < 1 || threadPriority > 10) {
            throw new IllegalArgumentException(String.format("The thread priority must be within (%s, %s) but it was %s.", 1, 10, threadPriority));
        }
        return Executors.newScheduledThreadPool(numThreads, (ThreadFactory)new ExecutorThreadFactory.Builder().setThreadPriority(threadPriority).setPoolName("Flink-" + componentName).build());
    }
}

