/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class LeaderInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final UUID leaderSessionID;
    @Nullable
    private final String leaderAddress;
    private static final LeaderInformation EMPTY = new LeaderInformation(null, null);

    private LeaderInformation(@Nullable UUID leaderSessionID, @Nullable String leaderAddress) {
        this.leaderSessionID = leaderSessionID;
        this.leaderAddress = leaderAddress;
    }

    @Nullable
    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }

    @Nullable
    public String getLeaderAddress() {
        return this.leaderAddress;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == LeaderInformation.class) {
            LeaderInformation that = (LeaderInformation)obj;
            return Objects.equals(this.leaderSessionID, that.leaderSessionID) && Objects.equals(this.leaderAddress, that.leaderAddress);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.leaderSessionID);
        result = 31 * result + Objects.hashCode(this.leaderAddress);
        return result;
    }

    public static LeaderInformation known(UUID leaderSessionID, String leaderAddress) {
        return new LeaderInformation((UUID)Preconditions.checkNotNull((Object)leaderSessionID), (String)Preconditions.checkNotNull((Object)leaderAddress));
    }

    public static LeaderInformation empty() {
        return EMPTY;
    }

    public String toString() {
        return "LeaderInformation{leaderSessionID='" + this.leaderSessionID + "', leaderAddress=" + this.leaderAddress + "}";
    }
}

