/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableMap;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ManagedMemoryUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ManagedMemoryUtils.class);
    private static final int MANAGED_MEMORY_FRACTION_SCALE = 16;
    private static final Map<ManagedMemoryUseCase, List<String>> USE_CASE_CONSUMER_NAMES = ImmutableMap.of((Object)ManagedMemoryUseCase.OPERATOR, (Object)ImmutableList.of((Object)"OPERATOR"), (Object)ManagedMemoryUseCase.STATE_BACKEND, (Object)ImmutableList.of((Object)"STATE_BACKEND"), (Object)ManagedMemoryUseCase.PYTHON, (Object)ImmutableList.of((Object)"PYTHON"));

    public static double convertToFractionOfSlot(ManagedMemoryUseCase useCase, double fractionOfUseCase, Set<ManagedMemoryUseCase> allUseCases, Configuration jobConfig, Configuration clusterConfig, Optional<Boolean> stateBackendFromApplicationUsesManagedMemory, ClassLoader classLoader) {
        Configuration config = new Configuration(clusterConfig);
        config.addAll(jobConfig);
        boolean stateBackendUsesManagedMemory = StateBackendLoader.stateBackendFromApplicationOrConfigOrDefaultUseManagedMemory(config, stateBackendFromApplicationUsesManagedMemory, classLoader);
        if (useCase.equals((Object)ManagedMemoryUseCase.STATE_BACKEND) && !stateBackendUsesManagedMemory) {
            return 0.0;
        }
        Map<ManagedMemoryUseCase, Integer> allUseCaseWeights = ManagedMemoryUtils.getManagedMemoryUseCaseWeightsFromConfig(clusterConfig);
        int totalWeights = allUseCases.stream().filter(uc -> !uc.equals((Object)ManagedMemoryUseCase.STATE_BACKEND) || stateBackendUsesManagedMemory).mapToInt(uc -> allUseCaseWeights.getOrDefault(uc, 0)).sum();
        int useCaseWeight = allUseCaseWeights.getOrDefault(useCase, 0);
        double useCaseFractionOfSlot = totalWeights > 0 ? ManagedMemoryUtils.getFractionRoundedDown(useCaseWeight, totalWeights) : 0.0;
        return fractionOfUseCase * useCaseFractionOfSlot;
    }

    @VisibleForTesting
    static Map<ManagedMemoryUseCase, Integer> getManagedMemoryUseCaseWeightsFromConfig(Configuration config) {
        Map configuredWeights = (Map)config.get(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS);
        HashMap<ManagedMemoryUseCase, Integer> effectiveWeights = new HashMap<ManagedMemoryUseCase, Integer>();
        for (Map.Entry<ManagedMemoryUseCase, List<String>> entry : USE_CASE_CONSUMER_NAMES.entrySet()) {
            ManagedMemoryUseCase useCase = entry.getKey();
            Iterator<String> nameIter = entry.getValue().iterator();
            boolean findWeight = false;
            while (!findWeight && nameIter.hasNext()) {
                String name = nameIter.next();
                String weightStr = (String)configuredWeights.get(name);
                if (weightStr == null) continue;
                int weight = Integer.parseInt(weightStr);
                findWeight = true;
                if (weight < 0) {
                    throw new IllegalConfigurationException(String.format("Managed memory weight should not be negative. Configured weight for %s is %d.", useCase, weight));
                }
                if (weight == 0) {
                    LOG.debug("Managed memory consumer weight for {} is configured to 0. Jobs containing this type of managed memory consumers may fail due to not being able to allocate managed memory.", (Object)useCase);
                }
                effectiveWeights.put(useCase, weight);
            }
            if (findWeight) continue;
            LOG.debug("Managed memory consumer weight for {} is not configured. Jobs containing this type of managed memory consumers may fail due to not being able to allocate managed memory.", (Object)useCase);
        }
        return effectiveWeights;
    }

    public static double getFractionRoundedDown(long dividend, long divisor) {
        return BigDecimal.valueOf(dividend).divide(BigDecimal.valueOf(divisor), 16, 1).doubleValue();
    }

    public static void validateUseCaseWeightsNotConflict(Map<ManagedMemoryUseCase, Integer> weights1, Map<ManagedMemoryUseCase, Integer> weights2) {
        weights1.forEach((useCase, weight1) -> Preconditions.checkState((boolean)weights2.getOrDefault(useCase, (Integer)weight1).equals(weight1), (Object)String.format("Conflict managed memory consumer weights for '%s' were configured: '%d' and '%d'.", useCase, weight1, weights2.get(useCase))));
    }
}

