/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.throughput.BufferDebloatConfiguration;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.util.PortRange;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyShuffleEnvironmentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(NettyShuffleEnvironmentConfiguration.class);
    private final int numNetworkBuffers;
    private final int networkBufferSize;
    private final int partitionRequestInitialBackoff;
    private final int partitionRequestMaxBackoff;
    private final int partitionRequestListenerTimeout;
    private final int networkBuffersPerChannel;
    private final int floatingNetworkBuffersPerGate;
    private final Optional<Integer> maxRequiredBuffersPerGate;
    private final int sortShuffleMinBuffers;
    private final int sortShuffleMinParallelism;
    private final long batchShuffleReadMemoryBytes;
    private final Duration requestSegmentsTimeout;
    private final boolean isNetworkDetailedMetrics;
    private final NettyConfig nettyConfig;
    private final String[] tempDirs;
    private final BoundedBlockingSubpartitionType blockingSubpartitionType;
    private final boolean batchShuffleCompressionEnabled;
    private final NettyShuffleEnvironmentOptions.CompressionCodec compressionCodec;
    private final int maxBuffersPerChannel;
    private final BufferDebloatConfiguration debloatConfiguration;
    private final boolean connectionReuseEnabled;
    private final int maxOverdraftBuffersPerGate;
    private final TieredStorageConfiguration tieredStorageConfiguration;

    public NettyShuffleEnvironmentConfiguration(int numNetworkBuffers, int networkBufferSize, int partitionRequestInitialBackoff, int partitionRequestMaxBackoff, int partitionRequestListenerTimeout, int networkBuffersPerChannel, int floatingNetworkBuffersPerGate, Optional<Integer> maxRequiredBuffersPerGate, Duration requestSegmentsTimeout, boolean isNetworkDetailedMetrics, @Nullable NettyConfig nettyConfig, String[] tempDirs, BoundedBlockingSubpartitionType blockingSubpartitionType, boolean batchShuffleCompressionEnabled, NettyShuffleEnvironmentOptions.CompressionCodec compressionCodec, int maxBuffersPerChannel, long batchShuffleReadMemoryBytes, int sortShuffleMinBuffers, int sortShuffleMinParallelism, BufferDebloatConfiguration debloatConfiguration, boolean connectionReuseEnabled, int maxOverdraftBuffersPerGate, @Nullable TieredStorageConfiguration tieredStorageConfiguration) {
        this.numNetworkBuffers = numNetworkBuffers;
        this.networkBufferSize = networkBufferSize;
        this.partitionRequestInitialBackoff = partitionRequestInitialBackoff;
        this.partitionRequestMaxBackoff = partitionRequestMaxBackoff;
        this.partitionRequestListenerTimeout = partitionRequestListenerTimeout;
        this.networkBuffersPerChannel = networkBuffersPerChannel;
        this.floatingNetworkBuffersPerGate = floatingNetworkBuffersPerGate;
        this.maxRequiredBuffersPerGate = maxRequiredBuffersPerGate;
        this.requestSegmentsTimeout = (Duration)Preconditions.checkNotNull((Object)requestSegmentsTimeout);
        this.isNetworkDetailedMetrics = isNetworkDetailedMetrics;
        this.nettyConfig = nettyConfig;
        this.tempDirs = (String[])Preconditions.checkNotNull((Object)tempDirs);
        this.blockingSubpartitionType = (BoundedBlockingSubpartitionType)((Object)Preconditions.checkNotNull((Object)((Object)blockingSubpartitionType)));
        this.batchShuffleCompressionEnabled = batchShuffleCompressionEnabled;
        this.compressionCodec = (NettyShuffleEnvironmentOptions.CompressionCodec)Preconditions.checkNotNull((Object)compressionCodec);
        this.maxBuffersPerChannel = maxBuffersPerChannel;
        this.batchShuffleReadMemoryBytes = batchShuffleReadMemoryBytes;
        this.sortShuffleMinBuffers = sortShuffleMinBuffers;
        this.sortShuffleMinParallelism = sortShuffleMinParallelism;
        this.debloatConfiguration = debloatConfiguration;
        this.connectionReuseEnabled = connectionReuseEnabled;
        this.maxOverdraftBuffersPerGate = maxOverdraftBuffersPerGate;
        this.tieredStorageConfiguration = tieredStorageConfiguration;
    }

    public int numNetworkBuffers() {
        return this.numNetworkBuffers;
    }

    public int networkBufferSize() {
        return this.networkBufferSize;
    }

    public int partitionRequestInitialBackoff() {
        return this.partitionRequestInitialBackoff;
    }

    public int partitionRequestMaxBackoff() {
        return this.partitionRequestMaxBackoff;
    }

    public int getPartitionRequestListenerTimeout() {
        return this.partitionRequestListenerTimeout;
    }

    public int networkBuffersPerChannel() {
        return this.networkBuffersPerChannel;
    }

    public int floatingNetworkBuffersPerGate() {
        return this.floatingNetworkBuffersPerGate;
    }

    public Optional<Integer> maxRequiredBuffersPerGate() {
        return this.maxRequiredBuffersPerGate;
    }

    public long batchShuffleReadMemoryBytes() {
        return this.batchShuffleReadMemoryBytes;
    }

    public int sortShuffleMinBuffers() {
        return this.sortShuffleMinBuffers;
    }

    public int sortShuffleMinParallelism() {
        return this.sortShuffleMinParallelism;
    }

    public Duration getRequestSegmentsTimeout() {
        return this.requestSegmentsTimeout;
    }

    public NettyConfig nettyConfig() {
        return this.nettyConfig;
    }

    public boolean isNetworkDetailedMetrics() {
        return this.isNetworkDetailedMetrics;
    }

    public String[] getTempDirs() {
        return this.tempDirs;
    }

    public boolean isConnectionReuseEnabled() {
        return this.connectionReuseEnabled;
    }

    public BoundedBlockingSubpartitionType getBlockingSubpartitionType() {
        return this.blockingSubpartitionType;
    }

    public boolean isBatchShuffleCompressionEnabled() {
        return this.batchShuffleCompressionEnabled;
    }

    public BufferDebloatConfiguration getDebloatConfiguration() {
        return this.debloatConfiguration;
    }

    public boolean isSSLEnabled() {
        return this.nettyConfig != null && this.nettyConfig.getSSLEnabled();
    }

    public NettyShuffleEnvironmentOptions.CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public int getMaxBuffersPerChannel() {
        return this.maxBuffersPerChannel;
    }

    public int getMaxOverdraftBuffersPerGate() {
        return this.maxOverdraftBuffersPerGate;
    }

    public TieredStorageConfiguration getTieredStorageConfiguration() {
        return this.tieredStorageConfiguration;
    }

    public static NettyShuffleEnvironmentConfiguration fromConfiguration(Configuration configuration, MemorySize networkMemorySize, boolean localTaskManagerCommunication, InetAddress taskManagerAddress) {
        PortRange dataBindPortRange = NettyShuffleEnvironmentConfiguration.getDataBindPortRange(configuration);
        int pageSize = ConfigurationParserUtils.getPageSize(configuration);
        NettyConfig nettyConfig = NettyShuffleEnvironmentConfiguration.createNettyConfig(configuration, localTaskManagerCommunication, taskManagerAddress, dataBindPortRange);
        int numberOfNetworkBuffers = NettyShuffleEnvironmentConfiguration.calculateNumberOfNetworkBuffers(networkMemorySize, pageSize);
        int initialRequestBackoff = (Integer)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_INITIAL);
        int maxRequestBackoff = (Integer)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_MAX);
        int listenerTimeout = (int)((Duration)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_PARTITION_REQUEST_TIMEOUT)).toMillis();
        int buffersPerChannel = 2;
        int extraBuffersPerGate = 8;
        Optional maxRequiredBuffersPerGate = configuration.getOptional(NettyShuffleEnvironmentOptions.NETWORK_READ_MAX_REQUIRED_BUFFERS_PER_GATE);
        int maxBuffersPerChannel = 10;
        long batchShuffleReadMemoryBytes = ((MemorySize)configuration.get(TaskManagerOptions.NETWORK_BATCH_SHUFFLE_READ_MEMORY)).getBytes();
        int sortShuffleMinBuffers = (Integer)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS);
        int sortShuffleMinParallelism = 1;
        boolean isNetworkDetailedMetrics = (Boolean)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_DETAILED_METRICS);
        String[] tempDirs = ConfigurationUtils.parseTempDirectories((Configuration)configuration);
        List<String> shuffleDirs = Arrays.asList(tempDirs);
        Collections.shuffle(shuffleDirs);
        Duration requestSegmentsTimeout = (Duration)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_REQUEST_TIMEOUT);
        BoundedBlockingSubpartitionType blockingSubpartitionType = BoundedBlockingSubpartitionType.FILE;
        NettyShuffleEnvironmentOptions.CompressionCodec compressionCodec = (NettyShuffleEnvironmentOptions.CompressionCodec)configuration.get(NettyShuffleEnvironmentOptions.SHUFFLE_COMPRESSION_CODEC);
        boolean batchShuffleCompressionEnabled = compressionCodec != NettyShuffleEnvironmentOptions.CompressionCodec.NONE;
        boolean connectionReuseEnabled = (Boolean)configuration.get(NettyShuffleEnvironmentOptions.TCP_CONNECTION_REUSE_ACROSS_JOBS_ENABLED);
        Preconditions.checkArgument((!maxRequiredBuffersPerGate.isPresent() || (Integer)maxRequiredBuffersPerGate.get() >= 1 ? 1 : 0) != 0, (Object)String.format("At least one buffer is required for each gate, please increase the value of %s.", NettyShuffleEnvironmentOptions.NETWORK_READ_MAX_REQUIRED_BUFFERS_PER_GATE.key()));
        TieredStorageConfiguration tieredStorageConfiguration = null;
        if (configuration.get(ExecutionOptions.BATCH_SHUFFLE_MODE) == BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL || configuration.get(ExecutionOptions.BATCH_SHUFFLE_MODE) == BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE) {
            tieredStorageConfiguration = TieredStorageConfiguration.fromConfiguration(configuration);
        }
        return new NettyShuffleEnvironmentConfiguration(numberOfNetworkBuffers, pageSize, initialRequestBackoff, maxRequestBackoff, listenerTimeout, buffersPerChannel, extraBuffersPerGate, maxRequiredBuffersPerGate, requestSegmentsTimeout, isNetworkDetailedMetrics, nettyConfig, shuffleDirs.toArray(tempDirs), blockingSubpartitionType, batchShuffleCompressionEnabled, compressionCodec, maxBuffersPerChannel, batchShuffleReadMemoryBytes, sortShuffleMinBuffers, sortShuffleMinParallelism, BufferDebloatConfiguration.fromConfiguration((ReadableConfig)configuration), connectionReuseEnabled, 20, tieredStorageConfiguration);
    }

    private static PortRange getDataBindPortRange(Configuration configuration) {
        if (configuration.contains(NettyShuffleEnvironmentOptions.DATA_BIND_PORT)) {
            String dataBindPort = (String)configuration.get(NettyShuffleEnvironmentOptions.DATA_BIND_PORT);
            return new PortRange(dataBindPort);
        }
        int dataBindPort = (Integer)configuration.get(NettyShuffleEnvironmentOptions.DATA_PORT);
        ConfigurationParserUtils.checkConfigParameter(dataBindPort >= 0, dataBindPort, NettyShuffleEnvironmentOptions.DATA_PORT.key(), "Leave config parameter empty or use 0 to let the system choose a port automatically.");
        return new PortRange(dataBindPort);
    }

    private static int calculateNumberOfNetworkBuffers(MemorySize networkMemorySize, int pageSize) {
        long numberOfNetworkBuffersLong = networkMemorySize.getBytes() / (long)pageSize;
        if (numberOfNetworkBuffersLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The given number of memory bytes (" + networkMemorySize.getBytes() + ") corresponds to more than MAX_INT pages.");
        }
        return (int)numberOfNetworkBuffersLong;
    }

    @Nullable
    private static NettyConfig createNettyConfig(Configuration configuration, boolean localTaskManagerCommunication, InetAddress taskManagerAddress, PortRange dataPortRange) {
        NettyConfig nettyConfig;
        if (!localTaskManagerCommunication) {
            InetSocketAddress taskManagerInetSocketAddress = new InetSocketAddress(taskManagerAddress, 0);
            nettyConfig = new NettyConfig(taskManagerInetSocketAddress.getAddress(), dataPortRange, ConfigurationParserUtils.getPageSize(configuration), ConfigurationParserUtils.getSlot(configuration), configuration);
        } else {
            nettyConfig = null;
        }
        return nettyConfig;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.numNetworkBuffers;
        result = 31 * result + this.networkBufferSize;
        result = 31 * result + this.partitionRequestInitialBackoff;
        result = 31 * result + this.partitionRequestMaxBackoff;
        result = 31 * result + this.partitionRequestListenerTimeout;
        result = 31 * result + this.networkBuffersPerChannel;
        result = 31 * result + this.floatingNetworkBuffersPerGate;
        result = 31 * result + this.requestSegmentsTimeout.hashCode();
        result = 31 * result + (this.nettyConfig != null ? this.nettyConfig.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.tempDirs);
        result = 31 * result + (this.batchShuffleCompressionEnabled ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.compressionCodec);
        result = 31 * result + this.maxBuffersPerChannel;
        result = 31 * result + Objects.hashCode(this.batchShuffleReadMemoryBytes);
        result = 31 * result + this.sortShuffleMinBuffers;
        result = 31 * result + this.sortShuffleMinParallelism;
        result = 31 * result + (this.connectionReuseEnabled ? 1 : 0);
        result = 31 * result + this.maxOverdraftBuffersPerGate;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NettyShuffleEnvironmentConfiguration that = (NettyShuffleEnvironmentConfiguration)obj;
        return this.numNetworkBuffers == that.numNetworkBuffers && this.networkBufferSize == that.networkBufferSize && this.partitionRequestInitialBackoff == that.partitionRequestInitialBackoff && this.partitionRequestMaxBackoff == that.partitionRequestMaxBackoff && this.networkBuffersPerChannel == that.networkBuffersPerChannel && this.floatingNetworkBuffersPerGate == that.floatingNetworkBuffersPerGate && this.batchShuffleReadMemoryBytes == that.batchShuffleReadMemoryBytes && this.sortShuffleMinBuffers == that.sortShuffleMinBuffers && this.sortShuffleMinParallelism == that.sortShuffleMinParallelism && this.requestSegmentsTimeout.equals(that.requestSegmentsTimeout) && (this.nettyConfig != null ? this.nettyConfig.equals(that.nettyConfig) : that.nettyConfig == null) && Arrays.equals(this.tempDirs, that.tempDirs) && this.batchShuffleCompressionEnabled == that.batchShuffleCompressionEnabled && this.maxBuffersPerChannel == that.maxBuffersPerChannel && this.partitionRequestListenerTimeout == that.partitionRequestListenerTimeout && Objects.equals(this.compressionCodec, that.compressionCodec) && this.connectionReuseEnabled == that.connectionReuseEnabled && this.maxOverdraftBuffersPerGate == that.maxOverdraftBuffersPerGate;
    }

    public String toString() {
        return "NettyShuffleEnvironmentConfiguration{, numNetworkBuffers=" + this.numNetworkBuffers + ", networkBufferSize=" + this.networkBufferSize + ", partitionRequestInitialBackoff=" + this.partitionRequestInitialBackoff + ", partitionRequestMaxBackoff=" + this.partitionRequestMaxBackoff + ", networkBuffersPerChannel=" + this.networkBuffersPerChannel + ", floatingNetworkBuffersPerGate=" + this.floatingNetworkBuffersPerGate + ", requestSegmentsTimeout=" + this.requestSegmentsTimeout + ", nettyConfig=" + this.nettyConfig + ", tempDirs=" + Arrays.toString(this.tempDirs) + ", blockingShuffleCompressionEnabled=" + this.batchShuffleCompressionEnabled + ", compressionCodec=" + this.compressionCodec + ", maxBuffersPerChannel=" + this.maxBuffersPerChannel + ", partitionRequestListenerTimeout" + this.partitionRequestListenerTimeout + ", batchShuffleReadMemoryBytes=" + this.batchShuffleReadMemoryBytes + ", sortShuffleMinBuffers=" + this.sortShuffleMinBuffers + ", sortShuffleMinParallelism=" + this.sortShuffleMinParallelism + ", connectionReuseEnabled=" + this.connectionReuseEnabled + ", maxOverdraftBuffersPerGate=" + this.maxOverdraftBuffersPerGate + "}";
    }
}

