/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import org.apache.flink.runtime.state.v2.AggregatingStateDescriptor;
import org.apache.flink.runtime.state.v2.ListStateDescriptor;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;
import org.apache.flink.runtime.state.v2.ReducingStateDescriptor;
import org.apache.flink.runtime.state.v2.StateDescriptor;
import org.apache.flink.runtime.state.v2.ValueStateDescriptor;

public class StateDescriptorUtils {
    private StateDescriptorUtils() {
    }

    public static org.apache.flink.api.common.state.StateDescriptor transformFromV2ToV1(StateDescriptor stateDescriptor) {
        switch (stateDescriptor.getType()) {
            case VALUE: {
                ValueStateDescriptor valueStateDesc = (ValueStateDescriptor)stateDescriptor;
                return new org.apache.flink.api.common.state.ValueStateDescriptor(valueStateDesc.getStateId(), valueStateDesc.getSerializer());
            }
            case MAP: {
                MapStateDescriptor mapStateDesc = (MapStateDescriptor)stateDescriptor;
                return new org.apache.flink.api.common.state.MapStateDescriptor(mapStateDesc.getStateId(), mapStateDesc.getUserKeySerializer(), mapStateDesc.getSerializer());
            }
            case LIST: {
                ListStateDescriptor listStateDesc = (ListStateDescriptor)stateDescriptor;
                return new org.apache.flink.api.common.state.ListStateDescriptor(listStateDesc.getStateId(), listStateDesc.getSerializer());
            }
            case REDUCING: {
                ReducingStateDescriptor reducingStateDesc = (ReducingStateDescriptor)stateDescriptor;
                return new org.apache.flink.api.common.state.ReducingStateDescriptor(reducingStateDesc.getStateId(), reducingStateDesc.getReduceFunction(), reducingStateDesc.getSerializer());
            }
            case AGGREGATING: {
                AggregatingStateDescriptor aggregatingStateDesc = (AggregatingStateDescriptor)stateDescriptor;
                return new org.apache.flink.api.common.state.AggregatingStateDescriptor(aggregatingStateDesc.getStateId(), aggregatingStateDesc.getAggregateFunction(), aggregatingStateDesc.getSerializer());
            }
        }
        throw new IllegalArgumentException("Unsupported state type: " + stateDescriptor.getType());
    }
}

