/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.messages.json.JobIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobDetails
implements Serializable {
    private static final long serialVersionUID = -3391462110304948766L;
    private static final String FIELD_NAME_JOB_ID = "jid";
    private static final String FIELD_NAME_JOB_NAME = "name";
    private static final String FIELD_NAME_START_TIME = "start-time";
    private static final String FIELD_NAME_END_TIME = "end-time";
    private static final String FIELD_NAME_DURATION = "duration";
    private static final String FIELD_NAME_STATUS = "state";
    private static final String FIELD_NAME_LAST_MODIFICATION = "last-modification";
    private static final String FIELD_NAME_TOTAL_NUMBER_TASKS = "total";
    private static final String FIELD_NAME_TASKS = "tasks";
    private final JobID jobId;
    private final String jobName;
    private final long startTime;
    private final long endTime;
    private final long duration;
    private final JobStatus status;
    private final long lastUpdateTime;
    private final int[] tasksPerState;
    private final int numTasks;
    private transient Map<String, Integer> lazyTaskInfo = null;
    private final Map<String, Map<Integer, CurrentAttempts>> currentExecutionAttempts;

    @JsonCreator
    public JobDetails(@JsonProperty(value="jid") @JsonDeserialize(using=JobIDDeserializer.class) JobID jobId, @JsonProperty(value="name") String jobName, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="state") JobStatus status, @JsonProperty(value="last-modification") long lastUpdateTime, @JsonProperty(value="tasks") Map<String, Integer> taskInfo) {
        this(jobId, jobName, startTime, endTime, duration, status, lastUpdateTime, JobDetails.extractNumTasksPerState(taskInfo), taskInfo.get(FIELD_NAME_TOTAL_NUMBER_TASKS));
    }

    @VisibleForTesting
    public JobDetails(JobID jobId, String jobName, long startTime, long endTime, long duration, JobStatus status, long lastUpdateTime, int[] tasksPerState, int numTasks) {
        this(jobId, jobName, startTime, endTime, duration, status, lastUpdateTime, tasksPerState, numTasks, new HashMap<String, Map<Integer, CurrentAttempts>>());
    }

    public JobDetails(JobID jobId, String jobName, long startTime, long endTime, long duration, JobStatus status, long lastUpdateTime, int[] tasksPerState, int numTasks, Map<String, Map<Integer, CurrentAttempts>> currentExecutionAttempts) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.status = (JobStatus)Preconditions.checkNotNull((Object)status);
        this.lastUpdateTime = lastUpdateTime;
        Preconditions.checkArgument((tasksPerState.length == ExecutionState.values().length ? 1 : 0) != 0, (String)"tasksPerState argument must be of size %s.", (Object[])new Object[]{ExecutionState.values().length});
        this.tasksPerState = (int[])Preconditions.checkNotNull((Object)tasksPerState);
        this.numTasks = numTasks;
        this.currentExecutionAttempts = (Map)Preconditions.checkNotNull(currentExecutionAttempts);
    }

    public static JobDetails createDetailsForJob(AccessExecutionGraph job) {
        JobStatus status = job.getState();
        long started = job.getStatusTimestamp(JobStatus.INITIALIZING);
        long finished = status.isGloballyTerminalState() ? job.getStatusTimestamp(status) : -1L;
        long duration = (finished >= 0L ? finished : System.currentTimeMillis()) - started;
        int[] countsPerStatus = new int[ExecutionState.values().length];
        long lastChanged = 0L;
        int numTotalTasks = 0;
        HashMap<String, Map<Integer, CurrentAttempts>> currentExecutionAttempts = new HashMap<String, Map<Integer, CurrentAttempts>>();
        for (AccessExecutionJobVertex accessExecutionJobVertex : job.getVerticesTopologically()) {
            AccessExecutionVertex[] taskVertices = accessExecutionJobVertex.getTaskVertices();
            numTotalTasks += taskVertices.length;
            HashMap<Integer, CurrentAttempts> vertexAttempts = new HashMap<Integer, CurrentAttempts>();
            for (AccessExecutionVertex taskVertex : taskVertices) {
                ExecutionState state = taskVertex.getExecutionState();
                int n = state.ordinal();
                countsPerStatus[n] = countsPerStatus[n] + 1;
                lastChanged = Math.max(lastChanged, taskVertex.getStateTimestamp(state));
                vertexAttempts.put(taskVertex.getParallelSubtaskIndex(), new CurrentAttempts(taskVertex.getCurrentExecutionAttempt().getAttemptNumber(), taskVertex.getCurrentExecutions().stream().map(AccessExecution::getAttemptNumber).collect(Collectors.toSet()), state.isTerminal()));
            }
            if (vertexAttempts.isEmpty()) continue;
            currentExecutionAttempts.put(String.valueOf(accessExecutionJobVertex.getJobVertexId()), vertexAttempts);
        }
        lastChanged = Math.max(lastChanged, finished);
        return new JobDetails(job.getJobID(), job.getJobName(), started, finished, duration, status, lastChanged, countsPerStatus, numTotalTasks, currentExecutionAttempts);
    }

    @JsonProperty(value="jid")
    @JsonSerialize(using=JobIDSerializer.class)
    public JobID getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="name")
    public String getJobName() {
        return this.jobName;
    }

    @JsonProperty(value="start-time")
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="end-time")
    public long getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="state")
    public JobStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="last-modification")
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @JsonProperty(value="tasks")
    public Map<String, Integer> getTaskInfo() {
        if (this.lazyTaskInfo == null) {
            HashMap<String, Integer> taskInfo = new HashMap<String, Integer>();
            taskInfo.put(FIELD_NAME_TOTAL_NUMBER_TASKS, this.getNumTasks());
            for (ExecutionState executionState : ExecutionState.values()) {
                taskInfo.put(executionState.name().toLowerCase(), this.tasksPerState[executionState.ordinal()]);
            }
            this.lazyTaskInfo = taskInfo;
        }
        return this.lazyTaskInfo;
    }

    @JsonIgnore
    public int getNumTasks() {
        return this.numTasks;
    }

    @JsonIgnore
    public int[] getTasksPerState() {
        return this.tasksPerState;
    }

    @JsonIgnore
    public Map<String, Map<Integer, CurrentAttempts>> getCurrentExecutionAttempts() {
        return this.currentExecutionAttempts;
    }

    private static int[] extractNumTasksPerState(Map<String, Integer> ex) {
        int[] tasksPerState = new int[ExecutionState.values().length];
        for (ExecutionState value : ExecutionState.values()) {
            tasksPerState[value.ordinal()] = ex.getOrDefault(value.name().toLowerCase(Locale.ROOT), 0);
        }
        return tasksPerState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == JobDetails.class) {
            JobDetails that = (JobDetails)o;
            return this.endTime == that.endTime && this.lastUpdateTime == that.lastUpdateTime && this.numTasks == that.numTasks && this.startTime == that.startTime && this.status == that.status && this.jobId.equals((Object)that.jobId) && this.jobName.equals(that.jobName) && Arrays.equals(this.tasksPerState, that.tasksPerState) && this.currentExecutionAttempts.equals(that.currentExecutionAttempts);
        }
        return false;
    }

    public int hashCode() {
        int result = this.jobId.hashCode();
        result = 31 * result + this.jobName.hashCode();
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.lastUpdateTime ^ this.lastUpdateTime >>> 32);
        result = 31 * result + Arrays.hashCode(this.tasksPerState);
        result = 31 * result + this.numTasks;
        result = 31 * result + this.currentExecutionAttempts.hashCode();
        return result;
    }

    public String toString() {
        return "JobDetails {jobId=" + this.jobId + ", jobName='" + this.jobName + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", status=" + this.status + ", lastUpdateTime=" + this.lastUpdateTime + ", numVerticesPerExecutionState=" + Arrays.toString(this.tasksPerState) + ", numTasks=" + this.numTasks + "}";
    }

    public static final class CurrentAttempts
    implements Serializable {
        private final int representativeAttempt;
        private final Set<Integer> currentAttempts;
        private final boolean isTerminalState;

        public CurrentAttempts(int representativeAttempt, Set<Integer> currentAttempts, boolean isTerminalState) {
            this.representativeAttempt = representativeAttempt;
            this.currentAttempts = Collections.unmodifiableSet(currentAttempts);
            this.isTerminalState = isTerminalState;
        }

        public int getRepresentativeAttempt() {
            return this.representativeAttempt;
        }

        public Set<Integer> getCurrentAttempts() {
            return this.currentAttempts;
        }

        public boolean isTerminalState() {
            return this.isTerminalState;
        }
    }
}

