/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.broadcast;

import org.apache.flink.runtime.jobgraph.JobVertexID;

public class BroadcastVariableKey {
    private final JobVertexID vertexId;
    private final String name;
    private final int superstep;

    public BroadcastVariableKey(JobVertexID vertexId, String name, int superstep) {
        if (vertexId == null || name == null || superstep <= 0) {
            throw new IllegalArgumentException();
        }
        this.vertexId = vertexId;
        this.name = name;
        this.superstep = superstep;
    }

    public JobVertexID getVertexId() {
        return this.vertexId;
    }

    public String getName() {
        return this.name;
    }

    public int getSuperstep() {
        return this.superstep;
    }

    public int hashCode() {
        return 31 * this.superstep + 47 * this.name.hashCode() + 83 * this.vertexId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == BroadcastVariableKey.class) {
            BroadcastVariableKey other = (BroadcastVariableKey)obj;
            return this.superstep == other.superstep && this.name.equals(other.name) && this.vertexId.equals(other.vertexId);
        }
        return false;
    }

    public String toString() {
        return this.vertexId + " \"" + this.name + "\" (" + this.superstep + ")";
    }
}

