/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.internal.InternalPartitionedState;

public class StateRequest<K, N, IN, OUT>
implements Serializable {
    @Nullable
    private final State state;
    private final StateRequestType type;
    @Nullable
    private final IN payload;
    private final InternalStateFuture<OUT> stateFuture;
    private final RecordContext<K> context;
    @Nullable
    private final N namespace;

    public StateRequest(@Nullable State state, StateRequestType type, @Nullable IN payload, InternalStateFuture<OUT> stateFuture, RecordContext<K> context) {
        this.state = state;
        this.type = type;
        this.payload = payload;
        this.stateFuture = stateFuture;
        this.context = context;
        this.namespace = state == null ? null : context.getNamespace((InternalPartitionedState)state);
    }

    public StateRequestType getRequestType() {
        return this.type;
    }

    @Nullable
    public IN getPayload() {
        return this.payload;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public InternalStateFuture<OUT> getFuture() {
        return this.stateFuture;
    }

    public RecordContext<K> getRecordContext() {
        return this.context;
    }

    @Nullable
    public N getNamespace() {
        return this.namespace;
    }
}

