/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class AddressResolutionTest {
    private static final RpcSystem RPC_SYSTEM = RpcSystem.load();
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String NON_EXISTING_HOSTNAME = "foo.bar.com.invalid";
    private static final int PORT = 17234;

    AddressResolutionTest() {
    }

    @BeforeAll
    static void check() {
        AddressResolutionTest.checkPreconditions();
    }

    private static void checkPreconditions() {
        boolean throwsException;
        try {
            InetAddress.getByName(NON_EXISTING_HOSTNAME);
            throwsException = false;
        }
        catch (UnknownHostException e) {
            throwsException = true;
        }
        Assumptions.assumeThat((boolean)throwsException).isTrue();
    }

    @Test
    void testNoAddressResolution() throws UnknownHostException {
        RPC_SYSTEM.getRpcUrl(NON_EXISTING_HOSTNAME, 17234, ENDPOINT_NAME, AddressResolution.NO_ADDRESS_RESOLUTION, new Configuration());
    }

    @Test
    void testTryAddressResolution() {
        Assertions.assertThatThrownBy(() -> RPC_SYSTEM.getRpcUrl(NON_EXISTING_HOSTNAME, 17234, ENDPOINT_NAME, AddressResolution.TRY_ADDRESS_RESOLUTION, new Configuration())).isInstanceOf(UnknownHostException.class);
    }
}

