/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.Canceling;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CancelingTest {
    private static final Logger log = LoggerFactory.getLogger(CancelingTest.class);

    CancelingTest() {
    }

    @Test
    void testExecutionGraphCancelationOnEnter() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph stateTrackingMockExecutionGraph = new StateTrackingMockExecutionGraph();
            this.createCancelingState(ctx, stateTrackingMockExecutionGraph);
            Assertions.assertThat((Comparable)stateTrackingMockExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELLING);
        }
    }

    @Test
    void testTransitionToFinishedWhenCancellationCompletes() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph stateTrackingMockExecutionGraph = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, stateTrackingMockExecutionGraph);
            Assertions.assertThat((Comparable)stateTrackingMockExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELLING);
            ctx.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELED);
            });
            stateTrackingMockExecutionGraph.completeTerminationFuture(JobStatus.CANCELED);
        }
    }

    @Test
    void testTransitionToSuspend() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            ctx.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED);
            });
            canceling.suspend((Throwable)new RuntimeException("suspend"));
        }
    }

    @Test
    void testCancelIsIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            canceling.cancel();
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testGlobalFailuresAreIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            canceling.handleGlobalFailure((Throwable)new RuntimeException("test"), FailureEnricherUtils.EMPTY_FAILURE_LABELS);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testTaskFailuresAreIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, meg);
            RuntimeException exception = new RuntimeException();
            TestingAccessExecution execution = TestingAccessExecution.newBuilder().withExecutionState(ExecutionState.FAILED).withErrorInfo(new ErrorInfo((Throwable)exception, System.currentTimeMillis())).build();
            meg.registerExecution(execution);
            TaskExecutionStateTransition update = ExecutingTest.createFailingStateTransition(execution.getAttemptId(), exception);
            canceling.updateTaskExecutionState(update, FailureEnricherUtils.EMPTY_FAILURE_LABELS);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    void testStateDoesNotExposeGloballyTerminalExecutionGraph() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, meg);
            ctx.setExpectFinished(eg -> {});
            meg.completeTerminationFuture(JobStatus.CANCELED);
            Assertions.assertThat((Comparable)meg.getState()).isEqualTo((Object)JobStatus.CANCELED);
            Assertions.assertThat((Comparable)canceling.getJobStatus()).isEqualTo((Object)JobStatus.CANCELLING);
            Assertions.assertThat((Comparable)canceling.getJob().getState()).isEqualTo((Object)JobStatus.CANCELLING);
            Assertions.assertThat((long)canceling.getJob().getStatusTimestamp(JobStatus.CANCELED)).isZero();
        }
    }

    private Canceling createCancelingState(MockStateWithExecutionGraphContext ctx, ExecutionGraph executionGraph) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, log, (Executor)ctx.getMainThreadExecutor(), ctx.getMainThreadExecutor());
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        executionGraph.transitionToRunning();
        Canceling canceling = new Canceling((StateWithExecutionGraph.Context)ctx, executionGraph, executionGraphHandler, (OperatorCoordinatorHandler)operatorCoordinatorHandler, log, ClassLoader.getSystemClassLoader(), new ArrayList());
        return canceling;
    }
}

