/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismStore;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultVertexParallelismStoreTest {
    DefaultVertexParallelismStoreTest() {
    }

    @Test
    void testNotSet() {
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> store.getParallelismInfo(new JobVertexID())).withFailMessage("No parallelism information set for vertex", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testSetInfo() {
        JobVertexID id = new JobVertexID();
        MockVertexParallelismInfo info = new MockVertexParallelismInfo();
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        store.setParallelismInfo(id, (VertexParallelismInformation)info);
        VertexParallelismInformation storedInfo = store.getParallelismInfo(id);
        Assertions.assertThat((Object)storedInfo).isEqualTo((Object)info);
    }

    private static final class MockVertexParallelismInfo
    implements VertexParallelismInformation {
        private MockVertexParallelismInfo() {
        }

        public int getMinParallelism() {
            return 0;
        }

        public int getParallelism() {
            return 0;
        }

        public int getMaxParallelism() {
            return 0;
        }

        public void setParallelism(int parallelism) {
        }

        public void setMaxParallelism(int maxParallelism) {
        }

        public boolean canRescaleMaxParallelism(int desiredMaxParallelism) {
            return false;
        }
    }
}

