/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination.util;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.operators.coordination.util.IncompleteFuturesTracker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IncompleteFuturesTrackerTest {
    IncompleteFuturesTrackerTest() {
    }

    @Test
    void testFutureTracked() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).containsExactly((Object[])new CompletableFuture[]{future});
    }

    @Test
    void testFutureRemovedAfterCompletion() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        tracker.trackFutureWhileIncomplete(future);
        future.complete(null);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).doesNotContain((Object[])new CompletableFuture[]{future});
    }

    @Test
    void testFutureNotAddedIfAlreadyCompleted() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        tracker.trackFutureWhileIncomplete(future);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).doesNotContain((Object[])new CompletableFuture[]{future});
    }

    @Test
    void testFailFutures() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        FlinkAssertions.assertThatFuture(future).eventuallyFailsWith(ExecutionException.class).withCause((Throwable)expectedException);
    }

    @Test
    void testFailFuturesImmediately() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        tracker.trackFutureWhileIncomplete(future);
        FlinkAssertions.assertThatFuture(future).eventuallyFailsWith(ExecutionException.class).withCause((Throwable)expectedException);
    }

    @Test
    void testResetClearsTrackedFutures() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        tracker.getCurrentIncompleteAndReset();
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).isEmpty();
    }
}

