/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.testutils.BinaryOperatorTestBase;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.apache.flink.util.Collector;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;

abstract class AbstractOuterJoinTaskExternalITCase
extends BinaryOperatorTestBase<FlatJoinFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
    protected static final long HASH_MEM = 0x400000L;
    private static final long SORT_MEM = 0x300000L;
    private static final long BNLJN_MEM = 327680L;
    private final double bnljn_frac;
    protected final TypeComparator<Tuple2<Integer, Integer>> comparator1 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
    protected final TypeComparator<Tuple2<Integer, Integer>> comparator2 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
    protected final TypeSerializer<Tuple2<Integer, Integer>> serializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{IntSerializer.INSTANCE, IntSerializer.INSTANCE});
    protected final BinaryOperatorTestBase.CountingOutputCollector<Tuple2<Integer, Integer>> output = new BinaryOperatorTestBase.CountingOutputCollector();

    AbstractOuterJoinTaskExternalITCase(ExecutionConfig config) {
        super(config, 0x400000L, 2, 0x300000L);
        this.bnljn_frac = 327680.0 / (double)this.getMemoryManager().getMemorySize();
    }

    @TestTemplate
    void testExternalSortOuterJoinTask() throws Exception {
        int keyCnt1 = 65536;
        int valCnt1 = 2;
        int keyCnt2 = 8192;
        int valCnt2 = 8;
        int expCnt = this.calculateExpectedCount(65536, 2, 8192, 8);
        this.setOutput(this.output);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(this.getSortStrategy());
        this.getTaskConfig().setRelativeMemoryDriver(this.bnljn_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInputSorted(new UniformIntTupleGenerator(65536, 2, false), this.serializer, this.comparator1.duplicate());
        this.addInputSorted(new UniformIntTupleGenerator(8192, 8, false), this.serializer, this.comparator2.duplicate());
        this.testDriver((Driver)testTask, MockJoinStub.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.output.getNumberOfRecords()).withFailMessage("Wrong result set size.", new Object[0])).isEqualTo(expCnt);
    }

    protected abstract int calculateExpectedCount(int var1, int var2, int var3, int var4);

    protected abstract AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> getOuterJoinDriver();

    protected abstract DriverStrategy getSortStrategy();

    public static final class MockJoinStub
    implements FlatJoinFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public void join(Tuple2<Integer, Integer> first, Tuple2<Integer, Integer> second, Collector<Tuple2<Integer, Integer>> out) throws Exception {
            out.collect(first != null ? first : second);
        }
    }
}

