/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.metrics.util.TestMeter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.metrics.CollectingMetricsReporter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.filter.DefaultMetricFilter;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterators;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricRegistryImplTest {
    private static final char GLOBAL_DEFAULT_DELIMITER = '.';

    MetricRegistryImplTest() {
    }

    @Test
    void testIsShutdown() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isFalse();
        metricRegistry.closeAsync().get();
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isTrue();
    }

    @Test
    void testMetricQueryServiceSetup() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        Assertions.assertThat((String)metricRegistry.getMetricQueryServiceGatewayRpcAddress()).isNull();
        metricRegistry.startQueryService((RpcService)new TestingRpcService(), new ResourceID("mqs"));
        MetricQueryServiceGateway metricQueryServiceGateway = metricRegistry.getMetricQueryServiceGateway();
        Assertions.assertThat((Object)metricQueryServiceGateway).isNotNull();
        metricRegistry.register((Metric)new SimpleCounter(), "counter", (AbstractMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup());
        boolean metricsSuccessfullyQueried = false;
        for (int x = 0; x < 10; ++x) {
            MetricDumpSerialization.MetricSerializationResult metricSerializationResult = (MetricDumpSerialization.MetricSerializationResult)metricQueryServiceGateway.queryMetrics(Time.seconds((long)5L)).get(5L, TimeUnit.SECONDS);
            if (metricSerializationResult.numCounters == 1) {
                metricsSuccessfullyQueried = true;
                continue;
            }
            Thread.sleep(50L);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)metricsSuccessfullyQueried).as("metrics query did not return expected result", new Object[0])).isTrue();
    }

    @Test
    void testReporterScheduling() throws Exception {
        MetricConfig config = new MetricConfig();
        config.setProperty("arg1", "hello");
        config.setProperty(MetricOptions.REPORTER_INTERVAL.key(), "50 MILLISECONDS");
        ReportCountingReporter reporter = new ReportCountingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.singletonList(ReporterSetup.forReporter((String)"test", (MetricConfig)config, (MetricReporter)reporter)));
        long start = System.currentTimeMillis();
        reporter.resetCount();
        for (int x = 0; x < 10; ++x) {
            Thread.sleep(100L);
            int reportCount = reporter.getReportCount();
            long curT = System.currentTimeMillis();
            long maxAllowedReports = (curT - start) / 50L + 2L;
            ((AbstractLongAssert)Assertions.assertThat((long)maxAllowedReports).as("Too many reports were triggered.", new Object[0])).isGreaterThanOrEqualTo((long)reportCount);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)reporter.getReportCount()).as("No report was triggered.", new Object[0])).isGreaterThan(0);
        registry.closeAsync().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testReporterIntervalParsingErrorFallsBackToDefaultValue() throws Exception {
        MetricConfig config = new MetricConfig();
        config.setProperty(MetricOptions.REPORTER_INTERVAL.key(), "1 UNICORN");
        ManuallyTriggeredScheduledExecutorService manuallyTriggeredScheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.singletonList(ReporterSetup.forReporter((String)"test", (MetricConfig)config, (MetricReporter)new ReportCountingReporter())), (ScheduledExecutorService)manuallyTriggeredScheduledExecutorService);
        try {
            Collection scheduledTasks = manuallyTriggeredScheduledExecutorService.getActiveScheduledTasks();
            ScheduledFuture reportTask = (ScheduledFuture)Iterators.getOnlyElement(scheduledTasks.iterator());
            Assertions.assertThat((long)reportTask.getDelay(TimeUnit.SECONDS)).isEqualTo(((Duration)MetricOptions.REPORTER_INTERVAL.defaultValue()).getSeconds());
        }
        finally {
            registry.closeAsync().get();
        }
    }

    @Test
    void testReporterNotifications() throws Exception {
        NotificationCapturingReporter reporter1 = new NotificationCapturingReporter();
        NotificationCapturingReporter reporter2 = new NotificationCapturingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)reporter1), ReporterSetup.forReporter((String)"test2", (MetricReporter)reporter2)));
        TaskManagerMetricGroup root = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        root.counter("rootCounter");
        Assertions.assertThat(reporter1.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(reporter2.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        root.close();
        Assertions.assertThat(reporter1.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(reporter2.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        registry.closeAsync().get();
    }

    @Test
    void testScopeConfig() {
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A");
        config.set(MetricOptions.SCOPE_NAMING_TM_JOB, (Object)"B");
        config.set(MetricOptions.SCOPE_NAMING_TASK, (Object)"C");
        config.set(MetricOptions.SCOPE_NAMING_OPERATOR, (Object)"D");
        ScopeFormats scopeConfig = ScopeFormats.fromConfig((Configuration)config);
        Assertions.assertThat((String)scopeConfig.getTaskManagerFormat().format()).isEqualTo("A");
        Assertions.assertThat((String)scopeConfig.getTaskManagerJobFormat().format()).isEqualTo("B");
        Assertions.assertThat((String)scopeConfig.getTaskFormat().format()).isEqualTo("C");
        Assertions.assertThat((String)scopeConfig.getOperatorFormat().format()).isEqualTo("D");
    }

    @Test
    void testConfigurableDelimiter() throws Exception {
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_DELIMITER, (Object)"_");
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A.B.C.D.E");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config), (Collection)ReporterSetup.fromConfiguration((Configuration)config, null));
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        Assertions.assertThat((String)tmGroup.getMetricIdentifier("name")).isEqualTo("A_B_C_D_E_name");
        registry.closeAsync().get();
    }

    @Test
    void testConfigurableDelimiterForReporters() throws Exception {
        MetricConfig config1 = new MetricConfig();
        config1.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)config1, (MetricReporter)new TestReporter()), ReporterSetup.forReporter((String)"test2", (MetricConfig)config2, (MetricReporter)new TestReporter()), ReporterSetup.forReporter((String)"test3", (MetricConfig)config3, (MetricReporter)new TestReporter())));
        Assertions.assertThat((char)registry.getDelimiter()).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(0)).isEqualTo('_');
        Assertions.assertThat((char)registry.getDelimiter(1)).isEqualTo('-');
        Assertions.assertThat((char)registry.getDelimiter(2)).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(3)).isEqualTo('.');
        Assertions.assertThat((char)registry.getDelimiter(-1)).isEqualTo('.');
        registry.closeAsync().get();
    }

    @Test
    void testConfigurableDelimiterForReportersInGroup() throws Exception {
        String name = "C";
        MetricConfig config1 = new MetricConfig();
        config1.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "AA");
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_TM, (Object)"A.B");
        List<ReporterSetup> reporterConfigurations = Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)config1, (MetricReporter)new CollectingMetricsReporter()), ReporterSetup.forReporter((String)"test2", (MetricConfig)config2, (MetricReporter)new CollectingMetricsReporter()), ReporterSetup.forReporter((String)"test3", (MetricConfig)config3, (MetricReporter)new CollectingMetricsReporter()), ReporterSetup.forReporter((String)"test4", (MetricReporter)new CollectingMetricsReporter()));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config), reporterConfigurations);
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        group.counter(name);
        group.close();
        registry.closeAsync().get();
        for (ReporterSetup cfg : reporterConfigurations) {
            String delimiter = cfg.getConfiguration().getProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key());
            if (delimiter == null || delimiter.equals("AA")) {
                delimiter = String.valueOf('.');
            }
            String expected = ((String)config.get(MetricOptions.SCOPE_NAMING_TM) + ".C").replaceAll("\\.", delimiter);
            CollectingMetricsReporter reporter = (CollectingMetricsReporter)cfg.getReporter();
            for (CollectingMetricsReporter.MetricGroupAndName groupAndName : Arrays.asList(reporter.findAdded(name), reporter.findRemoved(name))) {
                Assertions.assertThat((String)groupAndName.group.getMetricIdentifier(name)).isEqualTo(expected);
                Assertions.assertThat((String)groupAndName.group.getMetricIdentifier(name, (CharacterFilter)reporter)).isEqualTo(expected);
            }
        }
    }

    @Test
    void testQueryActorShutdown() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        TestingRpcService rpcService = new TestingRpcService();
        registry.startQueryService((RpcService)rpcService, null);
        MetricQueryService queryService = (MetricQueryService)Preconditions.checkNotNull((Object)registry.getQueryService());
        registry.closeAsync().get();
        queryService.getTerminationFuture().get();
    }

    @Test
    void testExceptionIsolation() throws Exception {
        NotificationCapturingReporter reporter1 = new NotificationCapturingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)new FailingReporter()), ReporterSetup.forReporter((String)"test2", (MetricReporter)reporter1)));
        SimpleCounter metric = new SimpleCounter();
        registry.register((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter1.getLastAddedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"counter");
        registry.unregister((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter1.getLastRemovedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"counter");
        registry.closeAsync().get();
    }

    @Test
    void testMetricFiltering() {
        String excludedMetricName = "excluded";
        NotificationCapturingReporter reporter = new NotificationCapturingReporter();
        Configuration reporterConfig = new Configuration();
        reporterConfig.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:counter"));
        reporterConfig.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:excluded"));
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test", (MetricFilter)DefaultMetricFilter.fromConfiguration((Configuration)reporterConfig), (MetricReporter)reporter)));
        registry.register((Metric)new TestMeter(), "", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isEmpty();
        registry.register((Metric)new TestCounter(), "excluded", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isEmpty();
        registry.register((Metric)new TestCounter(), "foo", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assertions.assertThat(reporter.getLastAddedMetric()).isNotEmpty();
    }

    private static class FailingReporter
    extends TestReporter {
        private FailingReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }
    }

    private static class NotificationCapturingReporter
    extends TestReporter {
        @Nullable
        private Metric addedMetric;
        @Nullable
        private String addedMetricName;
        @Nullable
        private Metric removedMetric;
        @Nullable
        private String removedMetricName;

        private NotificationCapturingReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            this.addedMetric = metric;
            this.addedMetricName = metricName;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            this.removedMetric = metric;
            this.removedMetricName = metricName;
        }

        public Optional<Metric> getLastAddedMetric() {
            return Optional.ofNullable(this.addedMetric);
        }

        public Optional<String> getLastAddedMetricName() {
            return Optional.ofNullable(this.addedMetricName);
        }

        public Optional<Metric> getLastRemovedMetric() {
            return Optional.ofNullable(this.removedMetric);
        }

        public Optional<String> getLastRemovedMetricName() {
            return Optional.ofNullable(this.removedMetricName);
        }
    }

    private static class ReportCountingReporter
    extends TestReporter
    implements Scheduled {
        private int reportCount = 0;

        private ReportCountingReporter() {
        }

        public void report() {
            ++this.reportCount;
        }

        public int getReportCount() {
            return this.reportCount;
        }

        public void resetCount() {
            this.reportCount = 0;
        }
    }
}

