/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SettableLeaderRetrievalServiceTest {
    private SettableLeaderRetrievalService settableLeaderRetrievalService;

    SettableLeaderRetrievalServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.settableLeaderRetrievalService = new SettableLeaderRetrievalService();
    }

    @Test
    void testNotifyListenerLater() throws Exception {
        String localhost = "localhost";
        this.settableLeaderRetrievalService.notifyListener("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingListener listener = new TestingListener();
        this.settableLeaderRetrievalService.start(listener);
        listener.waitForNewLeader();
        Assertions.assertThat((String)listener.getAddress()).isEqualTo("localhost");
        Assertions.assertThat((Comparable)listener.getLeaderSessionID()).isEqualTo((Object)HighAvailabilityServices.DEFAULT_LEADER_ID);
    }

    @Test
    void testNotifyListenerImmediately() throws Exception {
        TestingListener listener = new TestingListener();
        this.settableLeaderRetrievalService.start(listener);
        String localhost = "localhost";
        this.settableLeaderRetrievalService.notifyListener("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        listener.waitForNewLeader();
        Assertions.assertThat((String)listener.getAddress()).isEqualTo("localhost");
        Assertions.assertThat((Comparable)listener.getLeaderSessionID()).isEqualTo((Object)HighAvailabilityServices.DEFAULT_LEADER_ID);
    }
}

