/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderExtension;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class PhysicalSlotProviderImplWithDefaultSlotSelectionStrategyTest {
    @RegisterExtension
    private final PhysicalSlotProviderExtension physicalSlotProviderExtension = new PhysicalSlotProviderExtension((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault());

    PhysicalSlotProviderImplWithDefaultSlotSelectionStrategyTest() {
    }

    @Test
    void testSlotAllocationFulfilledWithAvailableSlots() throws InterruptedException, ExecutionException {
        PhysicalSlotRequest request = this.physicalSlotProviderExtension.createSimpleRequest();
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderExtension.allocateSlot(request);
        PhysicalSlotRequest.Result result = slotFuture.get();
        Assertions.assertThat((Comparable)result.getSlotRequestId()).isEqualTo((Object)request.getSlotRequestId());
    }

    @Test
    void testSlotAllocationFulfilledWithNewSlots() throws ExecutionException, InterruptedException {
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderExtension.allocateSlot(this.physicalSlotProviderExtension.createSimpleRequest());
        FlinkAssertions.assertThatFuture(slotFuture).isNotDone();
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        slotFuture.get();
    }

    @Test
    void testIndividualBatchSlotRequestTimeoutCheckIsDisabledOnAllocatingNewSlots() throws Exception {
        DeclarativeSlotPoolBridge slotPool = new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.physicalSlotProviderExtension.getMainThreadExecutor());
        Assertions.assertThat((boolean)slotPool.isBatchSlotRequestTimeoutCheckEnabled()).isTrue();
        PhysicalSlotProviderImpl slotProvider = new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)slotPool);
        slotProvider.disableBatchSlotRequestTimeoutCheck();
        Assertions.assertThat((boolean)slotPool.isBatchSlotRequestTimeoutCheckEnabled()).isFalse();
    }
}

