/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.junit.jupiter.api.BeforeEach;

abstract class InputGateTestBase {
    int gateIndex;

    InputGateTestBase() {
    }

    @BeforeEach
    void resetGateIndex() {
        this.gateIndex = 0;
    }

    protected void testIsAvailable(InputGate inputGateToTest, SingleInputGate inputGateToNotify, TestInputChannel inputChannelWithNewData) throws Exception {
        Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isNotDone();
        Assertions.assertThat((Optional)inputGateToTest.pollNext()).isNotPresent();
        CompletableFuture future = inputGateToTest.getAvailableFuture();
        Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isNotDone();
        Assertions.assertThat((Optional)inputGateToTest.pollNext()).isNotPresent();
        Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isEqualTo((Object)future);
        inputChannelWithNewData.readBuffer();
        inputGateToNotify.notifyChannelNonEmpty((InputChannel)inputChannelWithNewData);
        Assertions.assertThat((CompletableFuture)future).isDone();
        ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isDone()).isEqualTo((Object)PullingAsyncDataInput.AVAILABLE);
    }

    protected void testIsAvailableAfterFinished(InputGate inputGateToTest, Runnable endOfPartitionEvent) throws Exception {
        CompletableFuture available = inputGateToTest.getAvailableFuture();
        Assertions.assertThat((CompletableFuture)available).isNotDone();
        Assertions.assertThat((Optional)inputGateToTest.pollNext()).isNotPresent();
        endOfPartitionEvent.run();
        Assertions.assertThat((Optional)inputGateToTest.pollNext()).isNotEmpty();
        Assertions.assertThat((CompletableFuture)available).isDone();
        Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isDone();
        Assertions.assertThat((CompletableFuture)inputGateToTest.getAvailableFuture()).isEqualTo((Object)PullingAsyncDataInput.AVAILABLE);
    }

    protected SingleInputGate createInputGate() {
        return this.createInputGate(2);
    }

    protected SingleInputGate createInputGate(int numberOfInputChannels) {
        return this.createInputGate(null, numberOfInputChannels, ResultPartitionType.PIPELINED);
    }

    protected SingleInputGate createInputGate(NettyShuffleEnvironment environment, int numberOfInputChannels, ResultPartitionType partitionType) {
        SingleInputGateBuilder builder = new SingleInputGateBuilder().setNumberOfChannels(numberOfInputChannels).setSingleInputGateIndex(this.gateIndex++).setResultPartitionType(partitionType);
        if (environment != null) {
            builder = builder.setupBufferPoolFactory(environment);
        }
        SingleInputGate inputGate = builder.build();
        Assertions.assertThat((Comparable)inputGate.getConsumedPartitionType()).isEqualTo((Object)partitionType);
        return inputGate;
    }
}

