/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSegmentEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.EventAnnouncement;
import org.apache.flink.runtime.io.network.api.RecoveryMetadata;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.api.SubtaskConnectionDescriptor;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class EventSerializerTest {
    private final AbstractEvent[] events = new AbstractEvent[]{EndOfPartitionEvent.INSTANCE, EndOfSuperstepEvent.INSTANCE, new EndOfData(StopMode.DRAIN), new EndOfData(StopMode.NO_DRAIN), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)CheckpointType.FULL_CHECKPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.suspend((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.terminate((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.suspend((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.terminate((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new TestTaskEvent(Math.random(), 12361231273L), new CancelCheckpointMarker(287087987329842L), new EventAnnouncement((AbstractEvent)new CheckpointBarrier(42L, 1337L, CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (long)10L)), 44), new SubtaskConnectionDescriptor(23, 42), EndOfSegmentEvent.INSTANCE, new RecoveryMetadata(3)};

    EventSerializerTest() {
    }

    @Test
    void testSerializeDeserializeEvent() throws Exception {
        for (AbstractEvent evt : this.events) {
            ByteBuffer serializedEvent = EventSerializer.toSerializedEvent((AbstractEvent)evt);
            Assertions.assertThat((boolean)serializedEvent.hasRemaining()).isTrue();
            AbstractEvent deserialized = EventSerializer.fromSerializedEvent((ByteBuffer)serializedEvent, (ClassLoader)this.getClass().getClassLoader());
            ((ObjectAssert)Assertions.assertThat((Object)deserialized).isNotNull()).isEqualTo((Object)evt);
        }
    }

    @Test
    void testToBufferConsumer() throws IOException {
        for (AbstractEvent evt : this.events) {
            BufferConsumer bufferConsumer = EventSerializer.toBufferConsumer((AbstractEvent)evt, (boolean)false);
            Assertions.assertThat((boolean)bufferConsumer.isBuffer()).isFalse();
            Assertions.assertThat((boolean)bufferConsumer.isFinished()).isTrue();
            Assertions.assertThat((boolean)bufferConsumer.isDataAvailable()).isTrue();
            Assertions.assertThat((boolean)bufferConsumer.isRecycled()).isFalse();
            if (evt instanceof CheckpointBarrier) {
                Assertions.assertThat((boolean)bufferConsumer.build().getDataType().isBlockingUpstream()).isTrue();
                continue;
            }
            if (evt instanceof EndOfData) {
                Assertions.assertThat((Comparable)bufferConsumer.build().getDataType()).isEqualTo((Object)Buffer.DataType.END_OF_DATA);
                continue;
            }
            if (evt instanceof EndOfPartitionEvent) {
                Assertions.assertThat((Comparable)bufferConsumer.build().getDataType()).isEqualTo((Object)Buffer.DataType.END_OF_PARTITION);
                continue;
            }
            Assertions.assertThat((Comparable)bufferConsumer.build().getDataType()).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
        }
    }

    @Test
    void testToBuffer() throws IOException {
        for (AbstractEvent evt : this.events) {
            Buffer buffer = EventSerializer.toBuffer((AbstractEvent)evt, (boolean)false);
            Assertions.assertThat((boolean)buffer.isBuffer()).isFalse();
            Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
            Assertions.assertThat((boolean)buffer.isRecycled()).isFalse();
            if (evt instanceof CheckpointBarrier) {
                Assertions.assertThat((boolean)buffer.getDataType().isBlockingUpstream()).isTrue();
                continue;
            }
            if (evt instanceof EndOfData) {
                Assertions.assertThat((Comparable)buffer.getDataType()).isEqualTo((Object)Buffer.DataType.END_OF_DATA);
                continue;
            }
            if (evt instanceof EndOfPartitionEvent) {
                Assertions.assertThat((Comparable)buffer.getDataType()).isEqualTo((Object)Buffer.DataType.END_OF_PARTITION);
                continue;
            }
            Assertions.assertThat((Comparable)buffer.getDataType()).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
        }
    }
}

