/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import org.apache.flink.runtime.executiongraph.ExecutionVertexInputInfo;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.executiongraph.VertexInputInfoComputationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VertexInputInfoComputationUtilsTest {
    VertexInputInfoComputationUtilsTest() {
    }

    @Test
    void testComputeConsumedSubpartitionRange3to1() {
        IndexRange range = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(0, 1, 3);
        Assertions.assertThat((Object)range).isEqualTo((Object)new IndexRange(0, 2));
    }

    @Test
    void testComputeConsumedSubpartitionRange3to2() {
        IndexRange range1 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(0, 2, 3);
        Assertions.assertThat((Object)range1).isEqualTo((Object)new IndexRange(0, 0));
        IndexRange range2 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(1, 2, 3);
        Assertions.assertThat((Object)range2).isEqualTo((Object)new IndexRange(1, 2));
    }

    @Test
    void testComputeConsumedSubpartitionRange6to4() {
        IndexRange range1 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(0, 4, 6);
        Assertions.assertThat((Object)range1).isEqualTo((Object)new IndexRange(0, 0));
        IndexRange range2 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(1, 4, 6);
        Assertions.assertThat((Object)range2).isEqualTo((Object)new IndexRange(1, 2));
        IndexRange range3 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(2, 4, 6);
        Assertions.assertThat((Object)range3).isEqualTo((Object)new IndexRange(3, 3));
        IndexRange range4 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(3, 4, 6);
        Assertions.assertThat((Object)range4).isEqualTo((Object)new IndexRange(4, 5));
    }

    @Test
    void testComputeBroadcastConsumedSubpartitionRange() {
        IndexRange range1 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(0, 3, 1, true, true);
        Assertions.assertThat((Object)range1).isEqualTo((Object)new IndexRange(0, 0));
        IndexRange range2 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(1, 3, 1, true, true);
        Assertions.assertThat((Object)range2).isEqualTo((Object)new IndexRange(0, 0));
        IndexRange range3 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(2, 3, 1, true, true);
        Assertions.assertThat((Object)range3).isEqualTo((Object)new IndexRange(0, 0));
    }

    @Test
    void testComputeConsumedSubpartitionRangeForNonDynamicGraph() {
        IndexRange range1 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(0, 3, -1, false, false);
        Assertions.assertThat((Object)range1).isEqualTo((Object)new IndexRange(0, 0));
        IndexRange range2 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(1, 3, -1, false, false);
        Assertions.assertThat((Object)range2).isEqualTo((Object)new IndexRange(1, 1));
        IndexRange range3 = VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(2, 3, -1, false, false);
        Assertions.assertThat((Object)range3).isEqualTo((Object)new IndexRange(2, 2));
    }

    @Test
    void testComputeVertexInputInfoForAllToAllWithNonDynamicGraph() {
        JobVertexInputInfo nonBroadcast = VertexInputInfoComputationUtils.computeVertexInputInfoForAllToAll((int)2, (int)3, ignored -> 3, (boolean)false, (boolean)false);
        Assertions.assertThat((List)nonBroadcast.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 1), new IndexRange(0, 0)), new ExecutionVertexInputInfo(1, new IndexRange(0, 1), new IndexRange(1, 1)), new ExecutionVertexInputInfo(2, new IndexRange(0, 1), new IndexRange(2, 2))});
        JobVertexInputInfo broadcast = VertexInputInfoComputationUtils.computeVertexInputInfoForAllToAll((int)2, (int)3, ignored -> 3, (boolean)false, (boolean)true);
        Assertions.assertThat((List)broadcast.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 1), new IndexRange(0, 0)), new ExecutionVertexInputInfo(1, new IndexRange(0, 1), new IndexRange(1, 1)), new ExecutionVertexInputInfo(2, new IndexRange(0, 1), new IndexRange(2, 2))});
    }

    @Test
    void testComputeVertexInputInfoForAllToAllWithDynamicGraph() {
        JobVertexInputInfo nonBroadcast = VertexInputInfoComputationUtils.computeVertexInputInfoForAllToAll((int)2, (int)3, ignored -> 10, (boolean)true, (boolean)false);
        Assertions.assertThat((List)nonBroadcast.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 1), new IndexRange(0, 2)), new ExecutionVertexInputInfo(1, new IndexRange(0, 1), new IndexRange(3, 5)), new ExecutionVertexInputInfo(2, new IndexRange(0, 1), new IndexRange(6, 9))});
        JobVertexInputInfo broadcast = VertexInputInfoComputationUtils.computeVertexInputInfoForAllToAll((int)2, (int)3, ignored -> 1, (boolean)true, (boolean)true);
        Assertions.assertThat((List)broadcast.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 1), new IndexRange(0, 0)), new ExecutionVertexInputInfo(1, new IndexRange(0, 1), new IndexRange(0, 0)), new ExecutionVertexInputInfo(2, new IndexRange(0, 1), new IndexRange(0, 0))});
    }

    @Test
    void testComputeVertexInputInfoForPointwiseWithNonDynamicGraph() {
        JobVertexInputInfo jobVertexInputInfo = VertexInputInfoComputationUtils.computeVertexInputInfoForPointwise((int)2, (int)3, ignored -> 3, (boolean)false);
        Assertions.assertThat((List)jobVertexInputInfo.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 0), new IndexRange(0, 0)), new ExecutionVertexInputInfo(1, new IndexRange(0, 0), new IndexRange(1, 1)), new ExecutionVertexInputInfo(2, new IndexRange(1, 1), new IndexRange(0, 0))});
    }

    @Test
    void testComputeVertexInputInfoForPointwiseWithDynamicGraph() {
        JobVertexInputInfo jobVertexInputInfo = VertexInputInfoComputationUtils.computeVertexInputInfoForPointwise((int)2, (int)3, ignored -> 4, (boolean)true);
        Assertions.assertThat((List)jobVertexInputInfo.getExecutionVertexInputInfos()).containsExactlyInAnyOrder((Object[])new ExecutionVertexInputInfo[]{new ExecutionVertexInputInfo(0, new IndexRange(0, 0), new IndexRange(0, 1)), new ExecutionVertexInputInfo(1, new IndexRange(0, 0), new IndexRange(2, 3)), new ExecutionVertexInputInfo(2, new IndexRange(1, 1), new IndexRange(0, 3))});
    }

    private static IndexRange computeConsumedSubpartitionRange(int consumerIndex, int numConsumers, int numSubpartitions) {
        return VertexInputInfoComputationUtilsTest.computeConsumedSubpartitionRange(consumerIndex, numConsumers, numSubpartitions, true, false);
    }

    private static IndexRange computeConsumedSubpartitionRange(int consumerIndex, int numConsumers, int numSubpartitions, boolean isDynamicGraph, boolean isBroadcast) {
        return VertexInputInfoComputationUtils.computeConsumedSubpartitionRange((int)consumerIndex, (int)numConsumers, () -> numSubpartitions, (boolean)isDynamicGraph, (boolean)isBroadcast);
    }
}

