/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServices;
import org.apache.flink.runtime.dispatcher.TestingPartialDispatcherServices;
import org.apache.flink.runtime.dispatcher.runner.JobDispatcherLeaderProcessFactory;
import org.apache.flink.runtime.dispatcher.runner.JobDispatcherLeaderProcessFactoryFactory;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServicesBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobPersistenceComponentFactory;
import org.apache.flink.runtime.jobmanager.StandaloneJobGraphStore;
import org.apache.flink.runtime.jobmanager.TestingJobPersistenceComponentFactory;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.testutils.TestingJobResultStore;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
class JobDispatcherLeaderProcessFactoryFactoryTest {
    @TempDir
    private Path temporaryFolder;

    JobDispatcherLeaderProcessFactoryFactoryTest() {
    }

    @Test
    public void testJobGraphWithoutDirtyJobResult() throws IOException {
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        JobDispatcherLeaderProcessFactory factory = JobDispatcherLeaderProcessFactoryFactoryTest.createDispatcherLeaderProcessFactoryFromTestInstance(jobGraph, null, this.temporaryFolder);
        Assertions.assertThat((Object)factory.getJobGraph()).isEqualTo((Object)jobGraph);
        Assertions.assertThat((Object)factory.getRecoveredDirtyJobResult()).isNull();
    }

    @Test
    public void testJobGraphWithMatchingDirtyJobResult() throws IOException {
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        JobResult jobResult = TestingJobResultStore.createSuccessfulJobResult(jobGraph.getJobID());
        JobDispatcherLeaderProcessFactory factory = JobDispatcherLeaderProcessFactoryFactoryTest.createDispatcherLeaderProcessFactoryFromTestInstance(jobGraph, jobResult, this.temporaryFolder);
        Assertions.assertThat((Object)factory.getJobGraph()).isNull();
        Assertions.assertThat((Object)factory.getRecoveredDirtyJobResult()).isEqualTo((Object)jobResult);
    }

    @Test
    public void testJobGraphWithNotMatchingDirtyJobResult() throws IOException {
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        JobResult jobResult = TestingJobResultStore.createSuccessfulJobResult(new JobID());
        JobDispatcherLeaderProcessFactory factory = JobDispatcherLeaderProcessFactoryFactoryTest.createDispatcherLeaderProcessFactoryFromTestInstance(jobGraph, jobResult, this.temporaryFolder);
        Assertions.assertThat((Object)factory.getJobGraph()).isEqualTo((Object)jobGraph);
        Assertions.assertThat((Object)factory.getRecoveredDirtyJobResult()).isNull();
    }

    @Test
    public void testMissingJobGraph() throws IOException {
        Assertions.assertThatThrownBy(() -> JobDispatcherLeaderProcessFactoryFactoryTest.createDispatcherLeaderProcessFactoryFromTestInstance(null, TestingJobResultStore.createSuccessfulJobResult(new JobID()), this.temporaryFolder)).isInstanceOf(NullPointerException.class);
    }

    private static JobDispatcherLeaderProcessFactory createDispatcherLeaderProcessFactoryFromTestInstance(@Nullable JobGraph jobGraph, @Nullable JobResult dirtyJobResult, Path storageDir) throws IOException {
        JobDispatcherLeaderProcessFactoryFactory testInstance = new JobDispatcherLeaderProcessFactoryFactory(ignoredConfig -> jobGraph);
        TestingJobResultStore jobResultStore = TestingJobResultStore.builder().withGetDirtyResultsSupplier((SupplierWithException<Set<JobResult>, ? extends IOException>)((SupplierWithException)() -> CollectionUtil.ofNullable((Object)dirtyJobResult))).build();
        StandaloneJobGraphStore jobGraphStore = new StandaloneJobGraphStore();
        return testInstance.createFactory((JobPersistenceComponentFactory)new TestingJobPersistenceComponentFactory((JobGraphStore)jobGraphStore, jobResultStore), Executors.directExecutor(), (RpcService)new TestingRpcService(), (PartialDispatcherServices)TestingPartialDispatcherServices.builder().withHighAvailabilityServices(new TestingHighAvailabilityServicesBuilder().setJobGraphStore((JobGraphStore)jobGraphStore).setJobResultStore(jobResultStore).build()).build(storageDir.toFile(), new Configuration()), (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
    }
}

