/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfileTestingUtils;
import org.apache.flink.runtime.clusterframework.types.SlotSelectionStrategyTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTracker;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LocationPreferenceSlotSelectionStrategyTest
extends SlotSelectionStrategyTestBase {
    LocationPreferenceSlotSelectionStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        this.selectionStrategy = LocationPreferenceSlotSelectionStrategy.createDefault();
    }

    @Test
    void testPhysicalSlotResourceProfileRespected() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.biggerResourceProfile, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assertions.assertThat(match).hasValueSatisfying(slotInfoAndLocality -> Assertions.assertThat((boolean)slotInfoAndLocality.getSlotInfo().getResourceProfile().isMatching(slotProfile.getPhysicalSlotResourceProfile())).isTrue());
        ResourceProfile evenBiggerResourceProfile = ResourceProfile.fromResources((double)(this.biggerResourceProfile.getCpuCores().getValue().doubleValue() + 1.0), (int)this.resourceProfile.getTaskHeapMemory().getMebiBytes());
        SlotProfile slotProfileNotMatching = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)evenBiggerResourceProfile, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        match = this.runMatching(slotProfileNotMatching);
        Assertions.assertThat(match).isNotPresent();
    }

    @Test
    void matchNoRequirements() {
        SlotProfile slotProfile = SlotProfileTestingUtils.noRequirements();
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotLocalityAndInCandidates(match, Locality.UNCONSTRAINED, this.candidates);
    }

    @Test
    void returnsHostLocalMatchingIfExactTMLocationCannotBeFulfilled() {
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Collections.singletonList(this.tmlX));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotLocalityAndInCandidates(match, Locality.HOST_LOCAL, this.candidates);
    }

    @Test
    void returnsNonLocalMatchingIfResourceProfileCanBeFulfilledButNotTheTMLocationPreferences() throws Exception {
        InetAddress nonHostLocalInetAddress = InetAddress.getByAddress(new byte[]{10, 0, 0, 24});
        TaskManagerLocation nonLocalTm = new TaskManagerLocation(new ResourceID("non-local-tm"), nonHostLocalInetAddress, 42);
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Collections.singletonList(nonLocalTm));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotLocalityAndInCandidates(match, Locality.NON_LOCAL, this.candidates);
    }

    @Test
    void matchPreferredLocation() {
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.biggerResourceProfile, Collections.singletonList(this.tml2));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, this.slotInfo2);
        slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Arrays.asList(this.tmlX, this.tml4));
        match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, this.slotInfo4);
        slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Arrays.asList(this.tml3, this.tml1, this.tml3, this.tmlX));
        match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, this.slotInfo3);
    }

    @Test
    void matchPreviousLocationAvailableButAlsoBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml3), Collections.singletonList(this.aid3), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        LocationPreferenceSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, this.slotInfo3);
    }

    protected static void assertMatchingSlotEqualsToSlotInfo(Optional<SlotSelectionStrategy.SlotInfoAndLocality> matchingSlot, SlotInfo slotInfo) {
        Assertions.assertThat(matchingSlot).hasValueSatisfying(slotInfoAndLocality -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)slotInfoAndLocality.getSlotInfo()).isEqualTo((Object)slotInfo);
        });
    }

    protected static void assertMatchingSlotLocalityAndInCandidates(Optional<SlotSelectionStrategy.SlotInfoAndLocality> matchingSlot, Locality locality, FreeSlotInfoTracker candidates) {
        Assertions.assertThat(matchingSlot).hasValueSatisfying(slotInfoAndLocality -> {
            Assertions.assertThat((Comparable)slotInfoAndLocality.getLocality()).isEqualTo((Object)locality);
            Assertions.assertThat((Collection)candidates.getAvailableSlots()).anySatisfy(allocationId -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)candidates.getSlotInfo(allocationId)).isEqualTo((Object)slotInfoAndLocality.getSlotInfo());
            });
        });
    }
}

