/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.TestingBlobStore;
import org.apache.flink.util.function.TriFunctionWithException;

public class TestingBlobStoreBuilder {
    private static final TriFunctionWithException<File, JobID, BlobKey, Boolean, IOException> DEFAULT_PUT_FUNCTION = (ignoredA, ignoredB, ignoredC) -> true;
    private static final BiFunction<JobID, BlobKey, Boolean> DEFAULT_DELETE_FUNCTION = (ignoredA, ignoredB) -> true;
    private static final Function<JobID, Boolean> DEFAULT_DELETE_ALL_FUNCTION = ignored -> true;
    private static final TriFunctionWithException<JobID, BlobKey, File, Boolean, IOException> DEFAULT_GET_FUNCTION = (ignoredA, ignoredB, ignoredC) -> true;
    private TriFunctionWithException<File, JobID, BlobKey, Boolean, IOException> putFunction = DEFAULT_PUT_FUNCTION;
    private BiFunction<JobID, BlobKey, Boolean> deleteFunction = DEFAULT_DELETE_FUNCTION;
    private Function<JobID, Boolean> deleteAllFunction = DEFAULT_DELETE_ALL_FUNCTION;
    private TriFunctionWithException<JobID, BlobKey, File, Boolean, IOException> getFunction = DEFAULT_GET_FUNCTION;

    public TestingBlobStoreBuilder setPutFunction(TriFunctionWithException<File, JobID, BlobKey, Boolean, IOException> putFunction) {
        this.putFunction = putFunction;
        return this;
    }

    public TestingBlobStoreBuilder setDeleteFunction(BiFunction<JobID, BlobKey, Boolean> deleteFunction) {
        this.deleteFunction = deleteFunction;
        return this;
    }

    public TestingBlobStoreBuilder setDeleteAllFunction(Function<JobID, Boolean> deleteAllFunction) {
        this.deleteAllFunction = deleteAllFunction;
        return this;
    }

    public TestingBlobStoreBuilder setGetFunction(TriFunctionWithException<JobID, BlobKey, File, Boolean, IOException> getFunction) {
        this.getFunction = getFunction;
        return this;
    }

    public TestingBlobStore createTestingBlobStore() {
        return new TestingBlobStore(this.putFunction, this.deleteFunction, this.deleteAllFunction, this.getFunction);
    }
}

