/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.changelog.ChangelogStateBackendHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;

public class ChangelogStateBackendLocalHandle
implements ChangelogStateBackendHandle {
    private static final long serialVersionUID = 1L;
    private final List<KeyedStateHandle> localMaterialized;
    private final List<ChangelogStateHandle> localNonMaterialized;
    private final ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl remoteHandle;

    public ChangelogStateBackendLocalHandle(List<KeyedStateHandle> localMaterialized, List<ChangelogStateHandle> localNonMaterialized, ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl remoteHandle) {
        this.localMaterialized = localMaterialized;
        this.localNonMaterialized = localNonMaterialized;
        this.remoteHandle = remoteHandle;
    }

    @Override
    public List<KeyedStateHandle> getMaterializedStateHandles() {
        return this.localMaterialized;
    }

    @Override
    public List<ChangelogStateHandle> getNonMaterializedStateHandles() {
        return this.localNonMaterialized;
    }

    @Override
    public long getMaterializationID() {
        return this.remoteHandle.getMaterializationID();
    }

    @Override
    public ChangelogStateBackendHandle rebound(long checkpointId) {
        throw new UnsupportedOperationException("Should not call here.");
    }

    public List<KeyedStateHandle> getRemoteMaterializedStateHandles() {
        return this.remoteHandle.getMaterializedStateHandles();
    }

    public List<ChangelogStateHandle> getRemoteNonMaterializedStateHandles() {
        return this.remoteHandle.getNonMaterializedStateHandles();
    }

    @Override
    public long getCheckpointId() {
        return this.remoteHandle.getCheckpointId();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        this.remoteHandle.registerSharedStates(stateRegistry, checkpointID);
    }

    @Override
    public long getCheckpointedSize() {
        return this.remoteHandle.getCheckpointedSize();
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.remoteHandle.getKeyGroupRange();
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        throw new UnsupportedOperationException("This is a local state handle for the TM side only.");
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.remoteHandle.getStateHandleId();
    }

    @Override
    public void discardState() throws Exception {
    }

    @Override
    public long getStateSize() {
        return this.remoteHandle.getStateSize();
    }
}

