/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.taskexecutor.SampleableTask;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.RunnableWithException;

public class IdleTestTask
implements SampleableTask {
    private final ExecutionAttemptID executionAttemptID = ExecutionGraphTestUtils.createExecutionAttemptId();
    private final Thread thread;
    private volatile boolean stopped = false;

    public IdleTestTask() {
        this(10000L);
    }

    public IdleTestTask(long sleepDuration) {
        CountDownLatch startSignal = new CountDownLatch(1);
        this.thread = new Thread(() -> {
            while (!this.stopped) {
                try {
                    startSignal.countDown();
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
        try {
            startSignal.await();
        }
        catch (InterruptedException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public Thread getExecutingThread() {
        return this.thread;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionAttemptID;
    }

    public void start() {
        this.thread.setDaemon(true);
        this.thread.start();
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithTerminationGuarantee(RunnableWithException code, Set<IdleTestTask> tasks) throws Exception {
        try {
            code.run();
        }
        finally {
            for (IdleTestTask task : tasks) {
                task.stop();
            }
        }
    }
}

