/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProviderImpl;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LocalRecoveryDirectoryProviderImplTest {
    private static final JobID JOB_ID = new JobID();
    private static final JobVertexID JOB_VERTEX_ID = new JobVertexID();
    private static final int SUBTASK_INDEX = 0;
    @TempDir
    private Path tmpFolder;
    private LocalRecoveryDirectoryProviderImpl directoryProvider;
    private File[] allocBaseFolders;

    LocalRecoveryDirectoryProviderImplTest() {
    }

    @BeforeEach
    void setup() throws IOException {
        this.allocBaseFolders = new File[]{TempDirUtils.newFolder((Path)this.tmpFolder), TempDirUtils.newFolder((Path)this.tmpFolder), TempDirUtils.newFolder((Path)this.tmpFolder)};
        this.directoryProvider = new LocalRecoveryDirectoryProviderImpl(this.allocBaseFolders, JOB_ID, JOB_VERTEX_ID, 0);
    }

    @Test
    void allocationBaseDir() {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThat((File)this.directoryProvider.allocationBaseDirectory((long)i)).isEqualTo((Object)this.allocBaseFolders[i % this.allocBaseFolders.length]);
        }
    }

    @Test
    void selectAllocationBaseDir() {
        for (int i = 0; i < this.allocBaseFolders.length; ++i) {
            Assertions.assertThat((File)this.directoryProvider.selectAllocationBaseDirectory(i)).isEqualTo((Object)this.allocBaseFolders[i]);
        }
    }

    @Test
    void allocationBaseDirectoriesCount() {
        Assertions.assertThat((int)this.directoryProvider.allocationBaseDirsCount()).isEqualTo(this.allocBaseFolders.length);
    }

    @Test
    void subtaskSpecificDirectory() {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThat((File)this.directoryProvider.subtaskBaseDirectory((long)i)).isEqualTo((Object)new File(this.directoryProvider.allocationBaseDirectory((long)i), this.directoryProvider.subtaskDirString()));
        }
    }

    @Test
    void subtaskCheckpointSpecificDirectory() {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThat((File)this.directoryProvider.subtaskSpecificCheckpointDirectory((long)i)).isEqualTo((Object)new File(this.directoryProvider.subtaskBaseDirectory((long)i), this.directoryProvider.checkpointDirString((long)i)));
        }
    }

    @Test
    void testPathStringConstants() {
        Assertions.assertThat((String)this.directoryProvider.subtaskDirString()).isEqualTo("jid_" + JOB_ID + "/" + "vtx_" + JOB_VERTEX_ID + "_sti_" + 0);
        long checkpointId = 42L;
        Assertions.assertThat((String)this.directoryProvider.checkpointDirString(42L)).isEqualTo("chk_42");
    }

    @Test
    void testPreconditionsNotNullFiles() {
        Assertions.assertThatThrownBy(() -> new LocalRecoveryDirectoryProviderImpl(new File[]{null}, JOB_ID, JOB_VERTEX_ID, 0)).isInstanceOf(NullPointerException.class);
    }
}

