/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class KeyGroupPartitionerTestBase<T> {
    private static final DataOutputView DUMMY_OUT_VIEW = new DataOutputViewStreamWrapper((OutputStream)new ByteArrayOutputStreamWithPos(0));
    @Nonnull
    protected final KeyExtractorFunction<T> keyExtractorFunction;
    @Nonnull
    protected final Function<Random, T> elementGenerator;

    protected KeyGroupPartitionerTestBase(@Nonnull Function<Random, T> elementGenerator, @Nonnull KeyExtractorFunction<T> keyExtractorFunction) {
        this.elementGenerator = elementGenerator;
        this.keyExtractorFunction = keyExtractorFunction;
    }

    @Test
    void testPartitionByKeyGroup() throws IOException {
        Random random = new Random(66L);
        this.testPartitionByKeyGroupForSize(0, random);
        this.testPartitionByKeyGroupForSize(1, random);
        this.testPartitionByKeyGroupForSize(2, random);
        this.testPartitionByKeyGroupForSize(10, random);
    }

    private void testPartitionByKeyGroupForSize(int testSize, Random random) throws IOException {
        Set allElementsIdentitySet = Collections.newSetFromMap(new IdentityHashMap());
        K[] data = this.generateTestInput(random, testSize, allElementsIdentitySet);
        Assertions.assertThat(allElementsIdentitySet).hasSize(testSize);
        KeyGroupRange range = new KeyGroupRange(0, 4);
        int numberOfKeyGroups = range.getNumberOfKeyGroups();
        ValidatingElementWriterDummy<T> validatingElementWriter = new ValidatingElementWriterDummy<T>(this.keyExtractorFunction, numberOfKeyGroups, allElementsIdentitySet);
        KeyGroupPartitioner testInstance = this.createPartitioner(data, testSize, range, numberOfKeyGroups, validatingElementWriter);
        KeyGroupPartitioner.PartitioningResult result = testInstance.partitionByKeyGroup();
        for (int keyGroup = 0; keyGroup < numberOfKeyGroups; ++keyGroup) {
            validatingElementWriter.setCurrentKeyGroup(keyGroup);
            result.writeStateInKeyGroup(DUMMY_OUT_VIEW, keyGroup);
        }
        validatingElementWriter.validateAllElementsSeen();
    }

    @Test
    void testPartitionByKeyGroupWithIterator() throws IOException {
        Random random = new Random(66L);
        this.testPartitionByKeyGroupForSizeWithIterator(0, random);
        this.testPartitionByKeyGroupForSizeWithIterator(1, random);
        this.testPartitionByKeyGroupForSizeWithIterator(2, random);
        this.testPartitionByKeyGroupForSizeWithIterator(10, random);
    }

    private void testPartitionByKeyGroupForSizeWithIterator(int testSize, Random random) {
        KeyGroupRange range = new KeyGroupRange(0, 4);
        int numberOfKeyGroups = range.getNumberOfKeyGroups();
        Set allElementsIdentitySet = Collections.newSetFromMap(new IdentityHashMap());
        K[] data = this.generateTestInput(random, testSize, allElementsIdentitySet);
        Map<Integer, List> partitionedData = Arrays.stream(data).filter(Objects::nonNull).collect(Collectors.toMap(el -> this.computeKeyGroup(numberOfKeyGroups, el), xva$0 -> Arrays.asList(xva$0), (l1, l2) -> {
            ArrayList mergedList = new ArrayList(l1);
            mergedList.addAll(l2);
            return mergedList;
        }));
        KeyGroupPartitioner testInstance = this.createPartitioner(data, testSize, range, numberOfKeyGroups, new NoOpElementWriter());
        KeyGroupPartitioner.PartitioningResult result = testInstance.partitionByKeyGroup();
        for (int keyGroup = 0; keyGroup < numberOfKeyGroups; ++keyGroup) {
            Iterator iterator = result.iterator(keyGroup);
            Assertions.assertThat((List)CollectionUtil.iteratorToList((Iterator)iterator)).containsExactlyElementsOf((Iterable)partitionedData.getOrDefault(keyGroup, Collections.emptyList()));
        }
    }

    private int computeKeyGroup(int numberOfKeyGroups, T el) {
        return KeyGroupRangeAssignment.assignToKeyGroup((Object)this.keyExtractorFunction.extractKeyFromElement(el), (int)numberOfKeyGroups);
    }

    protected T[] generateTestInput(Random random, int numElementsToGenerate, Set<T> allElementsIdentitySet) {
        int arraySize = numElementsToGenerate > 1 ? numElementsToGenerate + 5 : numElementsToGenerate;
        T element = this.elementGenerator.apply(random);
        Object[] partitioningIn = (Object[])Array.newInstance(element.getClass(), arraySize);
        for (int i = 0; i < numElementsToGenerate; ++i) {
            partitioningIn[i] = element;
            allElementsIdentitySet.add(element);
            element = this.elementGenerator.apply(random);
        }
        Assertions.assertThat(allElementsIdentitySet).hasSize(numElementsToGenerate);
        return partitioningIn;
    }

    protected KeyGroupPartitioner<T> createPartitioner(T[] data, int numElements, KeyGroupRange keyGroupRange, int totalKeyGroups, KeyGroupPartitioner.ElementWriterFunction<T> elementWriterFunction) {
        Object[] partitioningOut = (Object[])Array.newInstance(data.getClass().getComponentType(), numElements);
        return new KeyGroupPartitioner((Object[])data, numElements, partitioningOut, keyGroupRange, totalKeyGroups, this.keyExtractorFunction, elementWriterFunction);
    }

    static final class ValidatingElementWriterDummy<T>
    implements KeyGroupPartitioner.ElementWriterFunction<T> {
        @Nonnull
        private final KeyExtractorFunction<T> keyExtractorFunction;
        @Nonnegative
        private final int numberOfKeyGroups;
        @Nonnull
        private final Set<T> allElementsSet;
        @Nonnegative
        private int currentKeyGroup;

        ValidatingElementWriterDummy(@Nonnull KeyExtractorFunction<T> keyExtractorFunction, @Nonnegative int numberOfKeyGroups, @Nonnull Set<T> allElementsSet) {
            this.keyExtractorFunction = keyExtractorFunction;
            this.numberOfKeyGroups = numberOfKeyGroups;
            this.allElementsSet = allElementsSet;
        }

        public void writeElement(@Nonnull T element, @Nonnull DataOutputView dov) {
            Assertions.assertThat((boolean)this.allElementsSet.remove(element)).isTrue();
            Assertions.assertThat((int)KeyGroupRangeAssignment.assignToKeyGroup((Object)this.keyExtractorFunction.extractKeyFromElement(element), (int)this.numberOfKeyGroups)).isEqualTo(this.currentKeyGroup);
        }

        void validateAllElementsSeen() {
            Assertions.assertThat(this.allElementsSet).isEmpty();
        }

        void setCurrentKeyGroup(int currentKeyGroup) {
            this.currentKeyGroup = currentKeyGroup;
        }
    }

    static final class NoOpElementWriter<T>
    implements KeyGroupPartitioner.ElementWriterFunction<T> {
        NoOpElementWriter() {
        }

        public void writeElement(@Nonnull T element, @Nonnull DataOutputView dov) throws IOException {
        }
    }
}

