/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.handler.InFlightRequestTracker;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InFlightRequestTrackerTest {
    private InFlightRequestTracker inFlightRequestTracker;

    InFlightRequestTrackerTest() {
    }

    @BeforeEach
    void setUp() {
        this.inFlightRequestTracker = new InFlightRequestTracker();
    }

    @Test
    void testShouldFinishAwaitAsyncImmediatelyIfNoRequests() {
        Assertions.assertThat((CompletableFuture)this.inFlightRequestTracker.awaitAsync()).isDone();
    }

    @Test
    void testShouldFinishAwaitAsyncIffAllRequestsDeregistered() {
        this.inFlightRequestTracker.registerRequest();
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assertions.assertThat((CompletableFuture)awaitFuture).isNotDone();
        this.inFlightRequestTracker.deregisterRequest();
        Assertions.assertThat((CompletableFuture)awaitFuture).isDone();
    }

    @Test
    void testAwaitAsyncIsIdempotent() {
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assertions.assertThat((CompletableFuture)awaitFuture).isDone();
        ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)awaitFuture).as("The reference to the future must not change", new Object[0])).isSameAs((Object)this.inFlightRequestTracker.awaitAsync());
    }

    @Test
    void testShouldTolerateRegisterAfterAwaitAsync() {
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assertions.assertThat((CompletableFuture)awaitFuture).isDone();
        this.inFlightRequestTracker.registerRequest();
        ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)awaitFuture).as("The reference to the future must not change", new Object[0])).isSameAs((Object)this.inFlightRequestTracker.awaitAsync());
    }

    @Test
    void testShouldNotRegisterNewRequestsAfterTermination() {
        CompletableFuture terminationFuture = this.inFlightRequestTracker.awaitAsync();
        Assertions.assertThat((CompletableFuture)terminationFuture).isDone();
        Assertions.assertThat((boolean)this.inFlightRequestTracker.registerRequest()).isFalse();
    }
}

