/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MemorySegmentSimpleTest {
    public static final long RANDOM_SEED = 643196033469871L;
    public static final int MANAGED_MEMORY_SIZE = 0x1000000;
    public static final int PAGE_SIZE = 524288;
    private MemoryManager manager;
    private MemorySegment segment;
    private Random random;

    MemorySegmentSimpleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.manager = MemoryManagerBuilder.newBuilder().setMemorySize(0x1000000L).setPageSize(524288).build();
        this.segment = (MemorySegment)this.manager.allocatePages((Object)new DummyInvokable(), 1).get(0);
        this.random = new Random(643196033469871L);
    }

    @AfterEach
    void tearDown() {
        this.manager.release(this.segment);
        this.random = null;
        this.segment = null;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.manager.verifyEmpty()).as("Not all memory has been properly released.", new Object[0])).isTrue();
        this.manager = null;
    }

    @Test
    void bulkByteAccess() {
        byte[] bytes = new byte[131072];
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.put(393217, bytes));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.put(458753, bytes, 0, bytes.length / 2));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        byte[] src = new byte[65536];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(src);
            this.segment.put(i * 65536, src);
        }
        this.random.setSeed(seed);
        byte[] expected = new byte[65536];
        byte[] actual = new byte[65536];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(expected);
            this.segment.get(i * 65536, actual);
            Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
        }
        byte[] expected2 = new byte[524288];
        this.random.nextBytes(expected2);
        for (int i = 0; i < 16; ++i) {
            this.segment.put(i * 32768, expected2, i * 32768, 32768);
        }
        byte[] actual2 = new byte[524288];
        for (int i = 0; i < 16; ++i) {
            this.segment.get(i * 32768, actual2, i * 32768, 32768);
        }
        Assertions.assertThat((byte[])actual2).isEqualTo((Object)expected2);
    }

    @Test
    void byteAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.put(-1, (byte)0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.put(524288, (byte)0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.get(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.get(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            this.segment.put(i, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            Assertions.assertThat((byte)this.segment.get(i)).isEqualTo((byte)this.random.nextInt());
        }
    }

    @Test
    void booleanAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putBoolean(-1, false));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putBoolean(524288, false));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getBoolean(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getBoolean(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            this.segment.putBoolean(i, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            Assertions.assertThat((boolean)this.segment.getBoolean(i)).isEqualTo(this.random.nextBoolean());
        }
    }

    @Test
    void charAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putChar(-1, 'a'));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putChar(524288, 'a'));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getChar(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getChar(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            this.segment.putChar(i, (char)(97 + this.random.nextInt(26)));
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            Assertions.assertThat((char)this.segment.getChar(i)).isEqualTo((char)(97 + this.random.nextInt(26)));
        }
    }

    @Test
    void doubleAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putDouble(-1, 0.0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putDouble(524288, 0.0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getDouble(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getDouble(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            this.segment.putDouble(i, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            Assertions.assertThat((double)this.segment.getDouble(i)).isCloseTo(this.random.nextDouble(), Offset.offset((Number)0.0));
        }
    }

    void floatAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putFloat(-1, 0.0f));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putFloat(524288, 0.0f));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getFloat(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getFloat(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            this.segment.putFloat(i, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            Assertions.assertThat((float)this.segment.getFloat(i)).isCloseTo(this.random.nextFloat(), Offset.offset((Number)Float.valueOf(0.0f)));
        }
    }

    @Test
    void longAccess() {
        int offset;
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putLong(-1, 0L));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putLong(524288, 0L));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getLong(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getLong(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            this.segment.putLong(i, this.random.nextLong());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            Assertions.assertThat((long)this.segment.getLong(i)).isEqualTo(this.random.nextLong());
        }
        seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (offset = 0; offset < 524280; offset += this.random.nextInt(24) + 8) {
            long value = this.random.nextLong();
            this.segment.putLong(offset, value);
        }
        this.random.setSeed(seed);
        for (offset = 0; offset < 524280; offset += this.random.nextInt(24) + 8) {
            long shouldValue = this.random.nextLong();
            long isValue = this.segment.getLong(offset);
            Assertions.assertThat((long)isValue).isEqualTo(shouldValue);
        }
    }

    @Test
    void intAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putInt(-1, 0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putInt(524288, 0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getInt(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getInt(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            this.segment.putInt(i, this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            Assertions.assertThat((int)this.segment.getInt(i)).isEqualTo(this.random.nextInt());
        }
    }

    @Test
    void shortAccess() {
        int i;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putShort(-1, (short)0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.putShort(524288, (short)0));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getShort(-1));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IndexOutOfBoundsException.class).as("IndexOutOfBoundsException expected", new Object[0])).isThrownBy(() -> this.segment.getShort(524288));
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            this.segment.putShort(i, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            Assertions.assertThat((short)this.segment.getShort(i)).isEqualTo((short)this.random.nextInt());
        }
    }

    @Test
    void testByteBufferWrapping() {
        MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        ByteBuffer buf1 = seg.wrap(13, 47);
        Assertions.assertThat((int)buf1.position()).isEqualTo(13);
        Assertions.assertThat((int)buf1.limit()).isEqualTo(60);
        Assertions.assertThat((int)buf1.remaining()).isEqualTo(47);
        ByteBuffer buf2 = seg.wrap(500, 267);
        Assertions.assertThat((int)buf2.position()).isEqualTo(500);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(767);
        Assertions.assertThat((int)buf2.remaining()).isEqualTo(267);
        ByteBuffer buf3 = seg.wrap(0, 1024);
        Assertions.assertThat((int)buf3.position()).isZero();
        Assertions.assertThat((int)buf3.limit()).isEqualTo(1024);
        Assertions.assertThat((int)buf3.remaining()).isEqualTo(1024);
    }

    @Test
    void testGetOffHeapBuffer() {
        MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalStateException.class).as("Memory segment does not represent off-heap buffer", new Object[0])).isThrownBy(() -> ((MemorySegment)seg).getOffHeapBuffer());
        seg.free();
        seg = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)1024);
        Assertions.assertThat((Comparable)seg.getOffHeapBuffer()).isNotNull();
        seg.free();
        seg = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)1024);
        Assertions.assertThat((Comparable)seg.getOffHeapBuffer()).isNotNull();
        seg.free();
    }
}

