/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultFreeSlotInfoTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTrackerTestUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultFreeSlotInfoTrackerTest {
    DefaultFreeSlotInfoTrackerTest() {
    }

    @Test
    void testReserveSlot() {
        ResourceID resourceId = ResourceID.generate();
        AllocatedSlot slotInfo1 = this.createAllocatedSlot(resourceId);
        AllocatedSlot slotInfo2 = this.createAllocatedSlot(resourceId);
        HashMap<AllocationID, SlotInfo> slots = new HashMap<AllocationID, SlotInfo>();
        slots.put(slotInfo1.getAllocationId(), (SlotInfo)slotInfo1);
        slots.put(slotInfo2.getAllocationId(), (SlotInfo)slotInfo2);
        DefaultFreeSlotInfoTracker freeSlotInfoTracker = FreeSlotInfoTrackerTestUtils.createDefaultFreeSlotInfoTracker(slots);
        Iterator iterator = freeSlotInfoTracker.getAvailableSlots().iterator();
        if (iterator.hasNext()) {
            AllocationID candidate = (AllocationID)iterator.next();
            SlotInfo selectSlot = freeSlotInfoTracker.getSlotInfo(candidate);
            Assertions.assertThat(slots.get(selectSlot.getAllocationId())).isEqualTo((Object)selectSlot);
            freeSlotInfoTracker.reserveSlot(selectSlot.getAllocationId());
        }
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)freeSlotInfoTracker.getAvailableSlots()).hasSize(1)).containsAnyOf((Object[])new AllocationID[]{slotInfo1.getAllocationId(), slotInfo2.getAllocationId()});
    }

    @Test
    void testCreatedFreeSlotInfoTrackerWithoutBlockedSlots() {
        ResourceID resourceId = ResourceID.generate();
        AllocatedSlot slotInfo1 = this.createAllocatedSlot(resourceId);
        AllocatedSlot slotInfo2 = this.createAllocatedSlot(resourceId);
        HashMap<AllocationID, SlotInfo> slots = new HashMap<AllocationID, SlotInfo>();
        slots.put(slotInfo1.getAllocationId(), (SlotInfo)slotInfo1);
        slots.put(slotInfo2.getAllocationId(), (SlotInfo)slotInfo2);
        DefaultFreeSlotInfoTracker freeSlotInfoTracker = FreeSlotInfoTrackerTestUtils.createDefaultFreeSlotInfoTracker(slots);
        Assertions.assertThat((Collection)freeSlotInfoTracker.getAvailableSlots()).hasSize(2);
        FreeSlotInfoTracker freeSlotInfoTrackerWithoutBlockedSlots = freeSlotInfoTracker.createNewFreeSlotInfoTrackerWithoutBlockedSlots(new HashSet<AllocationID>(Arrays.asList(slotInfo1.getAllocationId(), slotInfo2.getAllocationId())));
        Assertions.assertThat((Collection)freeSlotInfoTrackerWithoutBlockedSlots.getAvailableSlots()).isEmpty();
    }

    private AllocatedSlot createAllocatedSlot(ResourceID owner) {
        return new AllocatedSlot(new AllocationID(), new TaskManagerLocation(owner, InetAddress.getLoopbackAddress(), 41), 0, ResourceProfile.UNKNOWN, (TaskManagerGateway)new RpcTaskManagerGateway((TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway(), JobMasterId.generate()));
    }
}

