/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.io.File;
import java.io.IOException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierMasterAgent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RemoteTierMasterAgentTest {
    @TempDir
    private File tempFolder;

    RemoteTierMasterAgentTest() {
    }

    @Test
    void testAddAndReleasePartition() throws IOException {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        File partitionFile = new File(SegmentPartitionFile.getPartitionPath((TieredStoragePartitionId)partitionId, (String)this.tempFolder.getAbsolutePath()));
        Assertions.assertThat((boolean)partitionFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)partitionFile.exists()).isTrue();
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        RemoteTierMasterAgent masterAgent = new RemoteTierMasterAgent(this.tempFolder.getAbsolutePath(), resourceRegistry);
        masterAgent.addPartition(partitionId);
        Assertions.assertThat((boolean)partitionFile.exists()).isTrue();
        masterAgent.releasePartition(partitionId);
        Assertions.assertThat((boolean)partitionFile.exists()).isFalse();
    }
}

