/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.testutils.EmptyStreamStateHandle;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CompletedCheckpointTest {
    @Test
    void testCompareCheckpointsWithDifferentOrder() {
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(new JobID(), 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        checkpoints1.add(checkpoint2);
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        checkpoints2.add(checkpoint1);
        checkpoints2.add(checkpoint2);
        Assertions.assertThat((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2)).isFalse();
    }

    @Test
    void testCompareCheckpointsWithSameOrder() {
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(new JobID(), 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        checkpoints1.add(checkpoint2);
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint1);
        checkpoints2.add(checkpoint2);
        checkpoints2.add(checkpoint1);
        Assertions.assertThat((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2)).isTrue();
    }

    @Test
    void testCompareCheckpointsWithSameJobID() {
        JobID jobID = new JobID();
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(jobID, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(jobID, 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        Assertions.assertThat((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2)).isFalse();
    }

    @Test
    void testCompareCheckpointsWithSameCheckpointId() {
        JobID jobID1 = new JobID();
        JobID jobID2 = new JobID();
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(jobID1, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(jobID2, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        Assertions.assertThat((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2)).isFalse();
    }

    @Test
    void testRegisterStatesAtRegistry() {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, operatorStates, Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        checkpoint.registerSharedStatesAfterRestored((SharedStateRegistry)sharedStateRegistry, RestoreMode.DEFAULT);
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).registerSharedStates((SharedStateRegistry)sharedStateRegistry, 0L);
    }

    @Test
    void testCleanUpOnSubsume() throws Exception {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        EmptyStreamStateHandle metadata = new EmptyStreamStateHandle();
        TestCompletedCheckpointStorageLocation location = new TestCompletedCheckpointStorageLocation(metadata, "ptr");
        CheckpointProperties props = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, true, false, false, false, false, false);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, operatorStates, Collections.emptyList(), props, (CompletedCheckpointStorageLocation)location, null);
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        checkpoint.registerSharedStatesAfterRestored((SharedStateRegistry)sharedStateRegistry, RestoreMode.DEFAULT);
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).registerSharedStates((SharedStateRegistry)sharedStateRegistry, 0L);
        checkpoint.markAsDiscardedOnSubsume().discard();
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
        Assertions.assertThat((boolean)location.isDisposed()).isTrue();
        Assertions.assertThat((boolean)metadata.isDisposed()).isTrue();
    }

    @Test
    void testCleanUpOnShutdown() throws Exception {
        JobStatus[] terminalStates;
        for (JobStatus status : terminalStates = new JobStatus[]{JobStatus.FINISHED, JobStatus.CANCELED, JobStatus.FAILED, JobStatus.SUSPENDED}) {
            OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
            HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
            operatorStates.put(new OperatorID(), state);
            EmptyStreamStateHandle retainedHandle = new EmptyStreamStateHandle();
            TestCompletedCheckpointStorageLocation retainedLocation = new TestCompletedCheckpointStorageLocation(retainedHandle, "ptr");
            CheckpointProperties retainProps = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, false, false, false, false, false, false);
            CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), retainProps, (CompletedCheckpointStorageLocation)retainedLocation, null);
            checkpoint.markAsDiscardedOnShutdown(status).discard();
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)0))).discardState();
            Assertions.assertThat((boolean)retainedLocation.isDisposed()).isFalse();
            Assertions.assertThat((boolean)retainedHandle.isDisposed()).isFalse();
            EmptyStreamStateHandle discardHandle = new EmptyStreamStateHandle();
            TestCompletedCheckpointStorageLocation discardLocation = new TestCompletedCheckpointStorageLocation(discardHandle, "ptr");
            CheckpointProperties discardProps = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, true, true, true, true, true, false);
            checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), discardProps, (CompletedCheckpointStorageLocation)discardLocation, null);
            checkpoint.markAsDiscardedOnShutdown(status).discard();
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
            Assertions.assertThat((boolean)discardLocation.isDisposed()).isTrue();
            Assertions.assertThat((boolean)discardHandle.isDisposed()).isTrue();
        }
    }

    @Test
    void testCompletedCheckpointStatsCallbacks() throws Exception {
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        CompletedCheckpointStats checkpointStats = new CompletedCheckpointStats(1L, 0L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 1, 1L, 1L, 1L, true, (SubtaskStateStats)Mockito.mock(SubtaskStateStats.class), null);
        CompletedCheckpoint completed = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, Collections.emptyMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), checkpointStats);
        completed.markAsDiscardedOnShutdown(JobStatus.FINISHED).discard();
        Assertions.assertThat((boolean)checkpointStats.isDiscarded()).isTrue();
    }

    @Test
    void testIsJavaSerializable() throws Exception {
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CompletedCheckpointStats completed = new CompletedCheckpointStats(123123123L, 10123L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats, 1337, 123129837912L, 42L, 44L, true, new SubtaskStateStats(123, 213123L, 123123L, 123123L, 0L, 0L, 0L, 0L, 0L, 0L, false, true), null);
        CompletedCheckpointStats copy = (CompletedCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)completed);
        Assertions.assertThat((long)copy.getCheckpointId()).isEqualTo(completed.getCheckpointId());
        Assertions.assertThat((long)copy.getTriggerTimestamp()).isEqualTo(completed.getTriggerTimestamp());
        Assertions.assertThat((Object)copy.getProperties()).isEqualTo((Object)completed.getProperties());
        Assertions.assertThat((int)copy.getNumberOfSubtasks()).isEqualTo(completed.getNumberOfSubtasks());
        Assertions.assertThat((int)copy.getNumberOfAcknowledgedSubtasks()).isEqualTo(completed.getNumberOfAcknowledgedSubtasks());
        Assertions.assertThat((long)copy.getEndToEndDuration()).isEqualTo(completed.getEndToEndDuration());
        Assertions.assertThat((long)copy.getStateSize()).isEqualTo(completed.getStateSize());
        Assertions.assertThat((long)copy.getProcessedData()).isEqualTo(completed.getProcessedData());
        Assertions.assertThat((long)copy.getPersistedData()).isEqualTo(completed.getPersistedData());
        Assertions.assertThat((boolean)copy.isUnalignedCheckpoint()).isEqualTo(completed.isUnalignedCheckpoint());
        Assertions.assertThat((int)copy.getLatestAcknowledgedSubtaskStats().getSubtaskIndex()).isEqualTo(completed.getLatestAcknowledgedSubtaskStats().getSubtaskIndex());
        Assertions.assertThat((Comparable)copy.getStatus()).isEqualTo((Object)completed.getStatus());
    }
}

