/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.net.SSLUtilsTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class BlobClientSslTest
extends BlobClientTest {
    private static BlobServer blobSslServer;
    private static BlobServer blobNonSslServer;
    private static Configuration sslClientConfig;
    private static Configuration nonSslClientConfig;

    BlobClientSslTest() {
    }

    @BeforeAll
    static void startSSLServer() throws IOException {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores((String)SecurityOptions.SSL_PROVIDER.defaultValue());
        blobSslServer = TestingBlobUtils.createServer(tempDir.resolve("ssl"), config);
        blobSslServer.start();
        sslClientConfig = config;
    }

    @BeforeAll
    static void startNonSSLServer() throws IOException {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores((String)SecurityOptions.SSL_PROVIDER.defaultValue());
        config.set(BlobServerOptions.SSL_ENABLED, (Object)false);
        blobNonSslServer = TestingBlobUtils.createServer(tempDir.resolve("non_ssl"), config);
        blobNonSslServer.start();
        nonSslClientConfig = config;
    }

    @AfterAll
    static void stopServers() throws IOException {
        if (blobSslServer != null) {
            blobSslServer.close();
        }
        if (blobNonSslServer != null) {
            blobNonSslServer.close();
        }
    }

    @Override
    protected boolean isSSLEnabled() {
        return true;
    }

    @Override
    protected Configuration getBlobClientConfig() {
        return sslClientConfig;
    }

    @Override
    protected BlobServer getBlobServer() {
        return blobSslServer;
    }

    @Override
    @Test
    public void testUploadJarFilesHelper() throws Exception {
        BlobClientSslTest.uploadJarFile(blobSslServer, sslClientConfig);
    }

    @Test
    public void testSSLClientFailure() {
        Assertions.assertThatThrownBy(() -> BlobClientSslTest.uploadJarFile(blobServer, sslClientConfig)).isInstanceOf(IOException.class);
    }

    @Test
    public void testSSLClientFailure2() {
        Assertions.assertThatThrownBy(() -> BlobClientSslTest.uploadJarFile(blobNonSslServer, sslClientConfig)).isInstanceOf(IOException.class);
    }

    @Test
    public void testSSLServerFailure() {
        Assertions.assertThatThrownBy(() -> BlobClientSslTest.uploadJarFile(blobSslServer, clientConfig)).isInstanceOf(IOException.class);
    }

    @Test
    public void testSSLServerFailure2() throws Exception {
        Assertions.assertThatThrownBy(() -> BlobClientSslTest.uploadJarFile(blobSslServer, nonSslClientConfig)).isInstanceOf(IOException.class);
    }

    @Test
    public void testNonSSLConnection() throws Exception {
        BlobClientSslTest.uploadJarFile(blobServer, clientConfig);
    }

    @Test
    public void testNonSSLConnection2() throws Exception {
        BlobClientSslTest.uploadJarFile(blobServer, nonSslClientConfig);
    }

    @Test
    public void testNonSSLConnection3() throws Exception {
        BlobClientSslTest.uploadJarFile(blobNonSslServer, clientConfig);
    }

    @Test
    public void testNonSSLConnection4() throws Exception {
        BlobClientSslTest.uploadJarFile(blobNonSslServer, nonSslClientConfig);
    }
}

