/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;

public interface PartitionFileWriter {
    public CompletableFuture<Void> write(TieredStoragePartitionId var1, List<SubpartitionBufferContext> var2);

    public void release();

    public static class SegmentBufferContext {
        private final int segmentId;
        private final List<Tuple2<Buffer, Integer>> bufferAndIndexes;
        private final boolean segmentFinished;

        public SegmentBufferContext(int segmentId, List<Tuple2<Buffer, Integer>> bufferAndIndexes, boolean segmentFinished) {
            this.segmentId = segmentId;
            this.bufferAndIndexes = bufferAndIndexes;
            this.segmentFinished = segmentFinished;
        }

        public int getSegmentId() {
            return this.segmentId;
        }

        public List<Tuple2<Buffer, Integer>> getBufferAndIndexes() {
            return this.bufferAndIndexes;
        }

        public boolean isSegmentFinished() {
            return this.segmentFinished;
        }
    }

    public static class SubpartitionBufferContext {
        private final int subpartitionId;
        private final List<SegmentBufferContext> segmentBufferContexts;

        public SubpartitionBufferContext(int subpartitionId, List<SegmentBufferContext> segmentBufferContexts) {
            this.subpartitionId = subpartitionId;
            this.segmentBufferContexts = segmentBufferContexts;
        }

        public int getSubpartitionId() {
            return this.subpartitionId;
        }

        public List<SegmentBufferContext> getSegmentBufferContexts() {
            return this.segmentBufferContexts;
        }
    }
}

