/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatServicesImpl;
import org.apache.flink.runtime.heartbeat.NoOpHeartbeatServices;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public interface HeartbeatServices {
    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID var1, HeartbeatListener<I, O> var2, ScheduledExecutor var3, Logger var4);

    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID var1, HeartbeatListener<I, O> var2, ScheduledExecutor var3, Logger var4);

    public static HeartbeatServices fromConfiguration(Configuration configuration) {
        long heartbeatInterval = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_INTERVAL);
        long heartbeatTimeout = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT);
        int failedRpcRequestsUntilUnreachable = (Integer)configuration.get(HeartbeatManagerOptions.HEARTBEAT_RPC_FAILURE_THRESHOLD);
        return new HeartbeatServicesImpl(heartbeatInterval, heartbeatTimeout, failedRpcRequestsUntilUnreachable);
    }

    public static HeartbeatServices noOp() {
        return NoOpHeartbeatServices.getInstance();
    }
}

