/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.util.StringBasedID;

public class LogicalFile {
    LogicalFileId fileId;
    private long lastUsedCheckpointID = -1L;
    boolean discarded = false;
    @Nonnull
    private final PhysicalFile physicalFile;
    private final int startOffset;
    private final int length;
    @Nonnull
    private final FileMergingSnapshotManager.SubtaskKey subtaskKey;

    public LogicalFile(LogicalFileId fileId, @Nonnull PhysicalFile physicalFile, int startOffset, int length, @Nonnull FileMergingSnapshotManager.SubtaskKey subtaskKey) {
        this.fileId = fileId;
        this.physicalFile = physicalFile;
        this.startOffset = startOffset;
        this.length = length;
        this.subtaskKey = subtaskKey;
        physicalFile.incRefCount();
    }

    public LogicalFileId getFileId() {
        return this.fileId;
    }

    public void advanceLastCheckpointId(long checkpointId) {
        if (checkpointId > this.lastUsedCheckpointID) {
            this.lastUsedCheckpointID = checkpointId;
        }
    }

    public void discardWithCheckpointId(long checkpointId) throws IOException {
        if (!this.discarded && checkpointId >= this.lastUsedCheckpointID) {
            this.physicalFile.decRefCount();
            this.discarded = true;
        }
    }

    public long getLastUsedCheckpointID() {
        return this.lastUsedCheckpointID;
    }

    @Nonnull
    public PhysicalFile getPhysicalFile() {
        return this.physicalFile;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getLength() {
        return this.length;
    }

    @Nonnull
    public FileMergingSnapshotManager.SubtaskKey getSubtaskKey() {
        return this.subtaskKey;
    }

    @VisibleForTesting
    public boolean isDiscarded() {
        return this.discarded;
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalFile that = (LogicalFile)o;
        return this.fileId.equals((Object)that.fileId);
    }

    public static class LogicalFileId
    extends StringBasedID {
        public LogicalFileId(String keyString) {
            super(keyString);
        }

        public Path getFilePath() {
            return new Path(this.getKeyString());
        }

        public static LogicalFileId generateRandomId() {
            return new LogicalFileId(UUID.randomUUID().toString());
        }
    }
}

