/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterators;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class TaskStateSnapshot
implements CompositeStateHandle {
    private static final long serialVersionUID = 1L;
    public static final TaskStateSnapshot FINISHED_ON_RESTORE = new TaskStateSnapshot(new HashMap<OperatorID, OperatorSubtaskState>(), true, true);
    private final Map<OperatorID, OperatorSubtaskState> subtaskStatesByOperatorID;
    private final boolean isTaskDeployedAsFinished;
    private final boolean isTaskFinished;

    public TaskStateSnapshot() {
        this(10, false);
    }

    public TaskStateSnapshot(int size, boolean isTaskFinished) {
        this(CollectionUtil.newHashMapWithExpectedSize((int)size), false, isTaskFinished);
    }

    public TaskStateSnapshot(Map<OperatorID, OperatorSubtaskState> subtaskStatesByOperatorID) {
        this(subtaskStatesByOperatorID, false, false);
    }

    private TaskStateSnapshot(Map<OperatorID, OperatorSubtaskState> subtaskStatesByOperatorID, boolean isTaskDeployedAsFinished, boolean isTaskFinished) {
        this.subtaskStatesByOperatorID = (Map)Preconditions.checkNotNull(subtaskStatesByOperatorID);
        this.isTaskDeployedAsFinished = isTaskDeployedAsFinished;
        this.isTaskFinished = isTaskFinished;
    }

    public boolean isTaskDeployedAsFinished() {
        return this.isTaskDeployedAsFinished;
    }

    public boolean isTaskFinished() {
        return this.isTaskFinished;
    }

    @Nullable
    public OperatorSubtaskState getSubtaskStateByOperatorID(OperatorID operatorID) {
        return this.subtaskStatesByOperatorID.get((Object)operatorID);
    }

    public OperatorSubtaskState putSubtaskStateByOperatorID(@Nonnull OperatorID operatorID, @Nonnull OperatorSubtaskState state) {
        return this.subtaskStatesByOperatorID.put(operatorID, (OperatorSubtaskState)Preconditions.checkNotNull((Object)state));
    }

    public Set<Map.Entry<OperatorID, OperatorSubtaskState>> getSubtaskStateMappings() {
        return this.subtaskStatesByOperatorID.entrySet();
    }

    public boolean hasState() {
        for (OperatorSubtaskState operatorSubtaskState : this.subtaskStatesByOperatorID.values()) {
            if (operatorSubtaskState == null || !operatorSubtaskState.hasState()) continue;
            return true;
        }
        return this.isTaskDeployedAsFinished;
    }

    public InflightDataRescalingDescriptor getInputRescalingDescriptor() {
        return this.getMapping(OperatorSubtaskState::getInputRescalingDescriptor);
    }

    public InflightDataRescalingDescriptor getOutputRescalingDescriptor() {
        return this.getMapping(OperatorSubtaskState::getOutputRescalingDescriptor);
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.subtaskStatesByOperatorID.values());
    }

    @Override
    public long getStateSize() {
        long size = 0L;
        for (OperatorSubtaskState subtaskState : this.subtaskStatesByOperatorID.values()) {
            if (subtaskState == null) continue;
            size += subtaskState.getStateSize();
        }
        return size;
    }

    @Override
    public long getCheckpointedSize() {
        long size = 0L;
        for (OperatorSubtaskState subtaskState : this.subtaskStatesByOperatorID.values()) {
            if (subtaskState == null) continue;
            size += subtaskState.getCheckpointedSize();
        }
        return size;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        for (OperatorSubtaskState operatorSubtaskState : this.subtaskStatesByOperatorID.values()) {
            if (operatorSubtaskState == null) continue;
            operatorSubtaskState.registerSharedStates(stateRegistry, checkpointID);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStateSnapshot that = (TaskStateSnapshot)o;
        return this.subtaskStatesByOperatorID.equals(that.subtaskStatesByOperatorID) && this.isTaskDeployedAsFinished == that.isTaskDeployedAsFinished && this.isTaskFinished == that.isTaskFinished;
    }

    public int hashCode() {
        return Objects.hash(this.subtaskStatesByOperatorID, this.isTaskDeployedAsFinished, this.isTaskFinished);
    }

    public String toString() {
        return "TaskOperatorSubtaskStates{subtaskStatesByOperatorID=" + this.subtaskStatesByOperatorID + ", isTaskDeployedAsFinished=" + this.isTaskDeployedAsFinished + ", isTaskFinished=" + this.isTaskFinished + '}';
    }

    private InflightDataRescalingDescriptor getMapping(Function<OperatorSubtaskState, InflightDataRescalingDescriptor> mappingExtractor) {
        return (InflightDataRescalingDescriptor)Iterators.getOnlyElement(this.subtaskStatesByOperatorID.values().stream().map(mappingExtractor).filter(mapping -> !mapping.equals(InflightDataRescalingDescriptor.NO_RESCALE)).iterator(), (Object)InflightDataRescalingDescriptor.NO_RESCALE);
    }

    @Nullable
    public static SerializedValue<TaskStateSnapshot> serializeTaskStateSnapshot(TaskStateSnapshot subtaskState) {
        try {
            return subtaskState == null ? null : new SerializedValue((Object)subtaskState);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    @Nullable
    public static TaskStateSnapshot deserializeTaskStateSnapshot(SerializedValue<TaskStateSnapshot> subtaskState, ClassLoader classLoader) {
        try {
            return subtaskState == null ? null : (TaskStateSnapshot)subtaskState.deserializeValue(classLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }
}

