/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.webmonitor.history.HistoryServerUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HistoryServerUtilsTest
extends TestLogger {
    private static final String HOSTNAME = "foobar";
    private static final int PORT = 1234;

    @Test
    public void testIsSSLEnabledDefault() {
        Configuration configuration = new Configuration();
        Assert.assertThat((Object)HistoryServerUtils.isSSLEnabled((Configuration)configuration), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsSSLEnabledWithoutRestSSL() {
        Configuration configuration = new Configuration();
        configuration.setBoolean(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED, true);
        Assert.assertThat((Object)HistoryServerUtils.isSSLEnabled((Configuration)configuration), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsSSLEnabledOnlyRestSSL() {
        Configuration configuration = new Configuration();
        configuration.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        Assert.assertThat((Object)HistoryServerUtils.isSSLEnabled((Configuration)configuration), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsSSLEnabled() {
        Configuration configuration = new Configuration();
        this.enableSSL(configuration);
        Assert.assertThat((Object)HistoryServerUtils.isSSLEnabled((Configuration)configuration), (Matcher)Matchers.is((Object)true));
    }

    private void enableSSL(Configuration configuration) {
        configuration.setBoolean(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED, true);
        configuration.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
    }

    @Test
    public void testGetHistoryServerURL() throws MalformedURLException {
        Configuration configuration = this.createDefaultConfiguration();
        Optional historyServerURL = HistoryServerUtils.getHistoryServerURL((Configuration)configuration);
        Assert.assertThat(historyServerURL.get(), (Matcher)Matchers.is((Object)new URL("http", HOSTNAME, 1234, "")));
    }

    @Test
    public void testGetHistoryServerURLWithSSL() throws MalformedURLException {
        Configuration configuration = this.createDefaultConfiguration();
        this.enableSSL(configuration);
        Optional historyServerURL = HistoryServerUtils.getHistoryServerURL((Configuration)configuration);
        Assert.assertThat(historyServerURL.get(), (Matcher)Matchers.is((Object)new URL("https", HOSTNAME, 1234, "")));
    }

    @Test
    public void testGetHistoryServerURLWithoutHS() {
        Configuration configuration = new Configuration();
        Assert.assertThat((Object)HistoryServerUtils.getHistoryServerURL((Configuration)configuration).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Nonnull
    private Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setString(HistoryServerOptions.HISTORY_SERVER_WEB_ADDRESS, HOSTNAME);
        configuration.setInteger(HistoryServerOptions.HISTORY_SERVER_WEB_PORT, 1234);
        return configuration;
    }
}

