/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throwable;

import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableClassifier;
import org.apache.flink.runtime.throwable.ThrowableType;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ThrowableClassifierTest
extends TestLogger {
    @Test
    public void testThrowableType_NonRecoverable() {
        Assert.assertEquals((Object)ThrowableType.NonRecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new SuppressRestartsException((Throwable)new Exception(""))));
    }

    @Test
    public void testThrowableType_Recoverable() {
        Assert.assertEquals((Object)ThrowableType.RecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new Exception("")));
        Assert.assertEquals((Object)ThrowableType.RecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new TestRecoverableErrorException()));
    }

    @Test
    public void testThrowableType_EnvironmentError() {
        Assert.assertEquals((Object)ThrowableType.EnvironmentError, (Object)ThrowableClassifier.getThrowableType((Throwable)new TestEnvironmentErrorException()));
    }

    @Test
    public void testThrowableType_PartitionDataMissingError() {
        Assert.assertEquals((Object)ThrowableType.PartitionDataMissingError, (Object)ThrowableClassifier.getThrowableType((Throwable)new TestPartitionDataMissingErrorException()));
    }

    @Test
    public void testThrowableType_InheritError() {
        Assert.assertEquals((Object)ThrowableType.PartitionDataMissingError, (Object)ThrowableClassifier.getThrowableType((Throwable)new TestPartitionDataMissingErrorSubException()));
    }

    @Test
    public void testFindThrowableOfThrowableType() {
        Assert.assertFalse((boolean)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new Exception(), (ThrowableType)ThrowableType.RecoverableError).isPresent());
        Assert.assertFalse((boolean)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestPartitionDataMissingErrorException(), (ThrowableType)ThrowableType.RecoverableError).isPresent());
        Assert.assertTrue((boolean)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestRecoverableErrorException(), (ThrowableType)ThrowableType.RecoverableError).isPresent());
        Assert.assertTrue((boolean)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new Exception(new TestRecoverableErrorException()), (ThrowableType)ThrowableType.RecoverableError).isPresent());
        Assert.assertTrue((boolean)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestRecoverableFailureSubException(), (ThrowableType)ThrowableType.RecoverableError).isPresent());
    }

    private class TestRecoverableFailureSubException
    extends TestRecoverableErrorException {
        private TestRecoverableFailureSubException() {
        }
    }

    private class TestPartitionDataMissingErrorSubException
    extends TestPartitionDataMissingErrorException {
        private TestPartitionDataMissingErrorSubException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.RecoverableError)
    private class TestRecoverableErrorException
    extends Exception {
        private TestRecoverableErrorException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.EnvironmentError)
    private class TestEnvironmentErrorException
    extends Exception {
        private TestEnvironmentErrorException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.PartitionDataMissingError)
    private class TestPartitionDataMissingErrorException
    extends Exception {
        private TestPartitionDataMissingErrorException() {
        }
    }
}

