/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils.statemigration;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.Keyed;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.heap.AbstractHeapPriorityQueueElement;
import org.apache.flink.runtime.testutils.statemigration.V1TestTypeSerializerSnapshot;
import org.junit.Assert;

public class TestType
extends AbstractHeapPriorityQueueElement
implements PriorityComparable<TestType>,
Keyed<String> {
    private final int value;
    private final String key;

    public TestType(String key, int value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public int getValue() {
        return this.value;
    }

    public int comparePriorityTo(@Nonnull TestType other) {
        return Integer.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TestType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TestType other = (TestType)((Object)obj);
        return Objects.equals(this.key, other.key) && this.value == other.value;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.value;
    }

    public String toString() {
        return String.format("TestType(key='%s', value=%d)", this.key, this.value);
    }

    public static abstract class TestTypeSerializerBase
    extends TypeSerializer<TestType> {
        private static final long serialVersionUID = 256299937766275871L;

        public TestType copy(TestType from) {
            return new TestType(from.getKey(), from.getValue());
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.serialize(this.deserialize(source), target);
        }

        public TestType deserialize(TestType reuse, DataInputView source) throws IOException {
            return (TestType)((Object)this.deserialize(source));
        }

        public TestType copy(TestType from, TestType reuse) {
            return this.copy(from);
        }

        public TestType createInstance() {
            throw new UnsupportedOperationException();
        }

        public TypeSerializer<TestType> duplicate() {
            return this;
        }

        public boolean isImmutableType() {
            return false;
        }

        public int getLength() {
            return -1;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }

    public static class IncompatibleTestTypeSerializer
    extends TestTypeSerializerBase {
        private static final long serialVersionUID = -2959080770523247215L;

        public void serialize(TestType record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException("This is an incompatible serializer; shouldn't be used.");
        }

        public TestType deserialize(DataInputView source) throws IOException {
            throw new UnsupportedOperationException("This is an incompatible serializer; shouldn't be used.");
        }

        public TypeSerializerSnapshot<TestType> snapshotConfiguration() {
            throw new UnsupportedOperationException("This is an incompatible serializer; shouldn't be used.");
        }
    }

    public static class ReconfigurationRequiringTestTypeSerializer
    extends TestTypeSerializerBase {
        private static final long serialVersionUID = -7254527815207212324L;

        public void serialize(TestType record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException("The serializer should have been reconfigured as a new instance; shouldn't be used.");
        }

        public TestType deserialize(DataInputView source) throws IOException {
            throw new UnsupportedOperationException("The serializer should have been reconfigured as a new instance; shouldn't be used.");
        }

        public TypeSerializerSnapshot<TestType> snapshotConfiguration() {
            throw new UnsupportedOperationException("The serializer should have been reconfigured as a new instance; shouldn't be used.");
        }
    }

    public static class V2TestTypeSerializer
    extends TestTypeSerializerBase {
        private static final long serialVersionUID = 7199590310936186578L;
        private static final String RANDOM_PAYLOAD = "random-payload";

        public void serialize(TestType record, DataOutputView target) throws IOException {
            target.writeUTF(record.getKey());
            target.writeUTF(RANDOM_PAYLOAD);
            target.writeInt(record.getValue());
            target.writeBoolean(true);
        }

        public TestType deserialize(DataInputView source) throws IOException {
            String key = source.readUTF();
            Assert.assertEquals((Object)RANDOM_PAYLOAD, (Object)source.readUTF());
            int value = source.readInt();
            Assert.assertTrue((boolean)source.readBoolean());
            return new TestType(key, value);
        }

        public TypeSerializerSnapshot<TestType> snapshotConfiguration() {
            return new V1TestTypeSerializerSnapshot();
        }
    }

    public static class V1TestTypeSerializer
    extends TestTypeSerializerBase {
        private static final long serialVersionUID = 5053346160938769779L;

        public void serialize(TestType record, DataOutputView target) throws IOException {
            target.writeUTF(record.getKey());
            target.writeInt(record.getValue());
        }

        public TestType deserialize(DataInputView source) throws IOException {
            return new TestType(source.readUTF(), source.readInt());
        }

        public TypeSerializerSnapshot<TestType> snapshotConfiguration() {
            return new V1TestTypeSerializerSnapshot();
        }
    }
}

