/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl.mock;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalKvState;

abstract class MockInternalKvState<K, N, T>
implements InternalKvState<K, N, T> {
    Supplier<Map<Object, Object>> values;
    private N currentNamespace;
    private final Supplier<T> emptyValue;

    MockInternalKvState() {
        this(() -> null);
    }

    MockInternalKvState(Supplier<T> emptyValue) {
        this.emptyValue = emptyValue;
    }

    public TypeSerializer<K> getKeySerializer() {
        return null;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return null;
    }

    public TypeSerializer<T> getValueSerializer() {
        return null;
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = namespace;
    }

    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) {
        return null;
    }

    public void clear() {
        this.getCurrentKeyValues().remove(this.currentNamespace);
    }

    public T getInternal() {
        return (T)this.getCurrentKeyValues().computeIfAbsent(this.currentNamespace, n -> this.emptyValue.get());
    }

    public void updateInternal(T valueToStore) {
        this.getCurrentKeyValues().put(this.currentNamespace, valueToStore);
    }

    private Map<Object, Object> getCurrentKeyValues() {
        return this.values.get();
    }

    public InternalKvState.StateIncrementalVisitor<K, N, T> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        throw new UnsupportedOperationException();
    }
}

