/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.SequentialChannelStateReader;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.TestTaskStateManagerBuilder;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageLoader;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageView;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryStateChangelogStorage;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TestCheckpointResponder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.jetbrains.annotations.Nullable;

public class TestTaskStateManager
implements TaskStateManager {
    private long reportedCheckpointId;
    private long notifiedCompletedCheckpointId;
    private long notifiedAbortedCheckpointId;
    private final JobID jobId;
    private final ExecutionAttemptID executionAttemptID;
    private final Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId;
    private final Map<Long, TaskStateSnapshot> taskManagerTaskStateSnapshotsByCheckpointId;
    private final CheckpointResponder checkpointResponder;
    private final OneShotLatch waitForReportLatch;
    private final LocalRecoveryConfig localRecoveryDirectoryProvider;
    private final StateChangelogStorage<?> stateChangelogStorage;

    public TestTaskStateManager() {
        this(TestLocalRecoveryConfig.disabled());
    }

    public TestTaskStateManager(LocalRecoveryConfig localRecoveryConfig) {
        this(new JobID(), ExecutionGraphTestUtils.createExecutionAttemptId(), new TestCheckpointResponder(), localRecoveryConfig, (StateChangelogStorage<?>)new InMemoryStateChangelogStorage(), (Map<Long, TaskStateSnapshot>)new HashMap<Long, TaskStateSnapshot>(), -1L, new OneShotLatch());
    }

    public TestTaskStateManager(JobID jobId, ExecutionAttemptID executionAttemptID, CheckpointResponder checkpointResponder, LocalRecoveryConfig localRecoveryConfig, @javax.annotation.Nullable StateChangelogStorage<?> changelogStorage, Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId, long reportedCheckpointId, OneShotLatch waitForReportLatch) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.executionAttemptID = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptID);
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        this.localRecoveryDirectoryProvider = (LocalRecoveryConfig)Preconditions.checkNotNull((Object)localRecoveryConfig);
        this.stateChangelogStorage = changelogStorage;
        this.jobManagerTaskStateSnapshotsByCheckpointId = (Map)Preconditions.checkNotNull(jobManagerTaskStateSnapshotsByCheckpointId);
        this.taskManagerTaskStateSnapshotsByCheckpointId = new HashMap<Long, TaskStateSnapshot>();
        this.reportedCheckpointId = reportedCheckpointId;
        this.notifiedCompletedCheckpointId = -1L;
        this.notifiedAbortedCheckpointId = -1L;
        this.waitForReportLatch = (OneShotLatch)Preconditions.checkNotNull((Object)waitForReportLatch);
    }

    public void reportTaskStateSnapshots(@Nonnull CheckpointMetaData checkpointMetaData, @Nonnull CheckpointMetrics checkpointMetrics, @javax.annotation.Nullable TaskStateSnapshot acknowledgedState, @javax.annotation.Nullable TaskStateSnapshot localState) {
        this.jobManagerTaskStateSnapshotsByCheckpointId.put(checkpointMetaData.getCheckpointId(), acknowledgedState);
        this.taskManagerTaskStateSnapshotsByCheckpointId.put(checkpointMetaData.getCheckpointId(), localState);
        if (this.checkpointResponder != null) {
            this.checkpointResponder.acknowledgeCheckpoint(this.jobId, this.executionAttemptID, checkpointMetaData.getCheckpointId(), checkpointMetrics, acknowledgedState);
        }
        this.reportedCheckpointId = checkpointMetaData.getCheckpointId();
        if (this.waitForReportLatch != null) {
            this.waitForReportLatch.trigger();
        }
    }

    public InflightDataRescalingDescriptor getInputRescalingDescriptor() {
        return InflightDataRescalingDescriptor.NO_RESCALE;
    }

    public InflightDataRescalingDescriptor getOutputRescalingDescriptor() {
        return InflightDataRescalingDescriptor.NO_RESCALE;
    }

    public void reportIncompleteTaskStateSnapshots(CheckpointMetaData checkpointMetaData, CheckpointMetrics checkpointMetrics) {
        this.reportedCheckpointId = checkpointMetaData.getCheckpointId();
    }

    public boolean isTaskDeployedAsFinished() {
        TaskStateSnapshot jmTaskStateSnapshot = this.getLastJobManagerTaskStateSnapshot();
        if (jmTaskStateSnapshot != null) {
            return jmTaskStateSnapshot.isTaskDeployedAsFinished();
        }
        return false;
    }

    public Optional<Long> getRestoreCheckpointId() {
        TaskStateSnapshot jmTaskStateSnapshot = this.getLastJobManagerTaskStateSnapshot();
        if (jmTaskStateSnapshot == null) {
            return Optional.empty();
        }
        return Optional.of(this.reportedCheckpointId);
    }

    @Nonnull
    public PrioritizedOperatorSubtaskState prioritizedOperatorState(OperatorID operatorID) {
        OperatorSubtaskState tmOpState;
        TaskStateSnapshot jmTaskStateSnapshot = this.getLastJobManagerTaskStateSnapshot();
        TaskStateSnapshot tmTaskStateSnapshot = this.getLastTaskManagerTaskStateSnapshot();
        if (jmTaskStateSnapshot == null) {
            return PrioritizedOperatorSubtaskState.emptyNotRestored();
        }
        OperatorSubtaskState jmOpState = jmTaskStateSnapshot.getSubtaskStateByOperatorID(operatorID);
        if (jmOpState == null) {
            return PrioritizedOperatorSubtaskState.emptyNotRestored();
        }
        List<Object> tmStateCollection = Collections.emptyList();
        if (tmTaskStateSnapshot != null && (tmOpState = tmTaskStateSnapshot.getSubtaskStateByOperatorID(operatorID)) != null) {
            tmStateCollection = Collections.singletonList(tmOpState);
        }
        PrioritizedOperatorSubtaskState.Builder builder = new PrioritizedOperatorSubtaskState.Builder(jmOpState, tmStateCollection, Long.valueOf(this.reportedCheckpointId));
        return builder.build();
    }

    @Nonnull
    public LocalRecoveryConfig createLocalRecoveryConfig() {
        return (LocalRecoveryConfig)Preconditions.checkNotNull((Object)this.localRecoveryDirectoryProvider, (String)"Local state directory was never set for this test object!");
    }

    public SequentialChannelStateReader getSequentialChannelStateReader() {
        return SequentialChannelStateReader.NO_OP;
    }

    @javax.annotation.Nullable
    public StateChangelogStorage<?> getStateChangelogStorage() {
        return this.stateChangelogStorage;
    }

    @Nullable
    public StateChangelogStorageView<?> getStateChangelogStorageView(Configuration configuration, ChangelogStateHandle changelogStateHandle) {
        StateChangelogStorageView storageView = null;
        try {
            storageView = StateChangelogStorageLoader.loadFromStateHandle((Configuration)configuration, (ChangelogStateHandle)changelogStateHandle);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        return storageView;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.notifiedCompletedCheckpointId = checkpointId;
    }

    public void notifyCheckpointAborted(long checkpointId) {
        this.notifiedAbortedCheckpointId = checkpointId;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ExecutionAttemptID getExecutionAttemptID() {
        return this.executionAttemptID;
    }

    public CheckpointResponder getCheckpointResponder() {
        return this.checkpointResponder;
    }

    public Map<Long, TaskStateSnapshot> getJobManagerTaskStateSnapshotsByCheckpointId() {
        return this.jobManagerTaskStateSnapshotsByCheckpointId;
    }

    public void setJobManagerTaskStateSnapshotsByCheckpointId(Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId) {
        this.jobManagerTaskStateSnapshotsByCheckpointId.clear();
        this.jobManagerTaskStateSnapshotsByCheckpointId.putAll(jobManagerTaskStateSnapshotsByCheckpointId);
    }

    public Map<Long, TaskStateSnapshot> getTaskManagerTaskStateSnapshotsByCheckpointId() {
        return this.taskManagerTaskStateSnapshotsByCheckpointId;
    }

    public void setTaskManagerTaskStateSnapshotsByCheckpointId(Map<Long, TaskStateSnapshot> taskManagerTaskStateSnapshotsByCheckpointId) {
        this.taskManagerTaskStateSnapshotsByCheckpointId.clear();
        this.taskManagerTaskStateSnapshotsByCheckpointId.putAll(taskManagerTaskStateSnapshotsByCheckpointId);
    }

    public long getReportedCheckpointId() {
        return this.reportedCheckpointId;
    }

    public long getNotifiedCompletedCheckpointId() {
        return this.notifiedCompletedCheckpointId;
    }

    public long getNotifiedAbortedCheckpointId() {
        return this.notifiedAbortedCheckpointId;
    }

    public void setReportedCheckpointId(long reportedCheckpointId) {
        this.reportedCheckpointId = reportedCheckpointId;
    }

    public TaskStateSnapshot getLastJobManagerTaskStateSnapshot() {
        return this.jobManagerTaskStateSnapshotsByCheckpointId != null ? this.jobManagerTaskStateSnapshotsByCheckpointId.get(this.reportedCheckpointId) : null;
    }

    public TaskStateSnapshot getLastTaskManagerTaskStateSnapshot() {
        return this.taskManagerTaskStateSnapshotsByCheckpointId != null ? this.taskManagerTaskStateSnapshotsByCheckpointId.get(this.reportedCheckpointId) : null;
    }

    public OneShotLatch getWaitForReportLatch() {
        return this.waitForReportLatch;
    }

    public void restoreLatestCheckpointState(Map<Long, TaskStateSnapshot> taskStateSnapshotsByCheckpointId) {
        if (taskStateSnapshotsByCheckpointId == null || taskStateSnapshotsByCheckpointId.isEmpty()) {
            return;
        }
        long latestId = -1L;
        for (long id : taskStateSnapshotsByCheckpointId.keySet()) {
            if (id <= latestId) continue;
            latestId = id;
        }
        this.setReportedCheckpointId(latestId);
        this.setJobManagerTaskStateSnapshotsByCheckpointId(taskStateSnapshotsByCheckpointId);
    }

    public void close() throws Exception {
    }

    public static TestTaskStateManagerBuilder builder() {
        return new TestTaskStateManagerBuilder();
    }
}

