/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.LongPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.TaskLocalStateStore;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.util.Preconditions;

public class TestTaskLocalStateStore
implements TaskLocalStateStore {
    private final SortedMap<Long, TaskStateSnapshot> taskStateSnapshotsByCheckpointID;
    private final LocalRecoveryConfig localRecoveryConfig;
    private boolean disposed;

    public TestTaskLocalStateStore() {
        this(TestLocalRecoveryConfig.disabled());
    }

    public TestTaskLocalStateStore(@Nonnull LocalRecoveryConfig localRecoveryConfig) {
        this.localRecoveryConfig = localRecoveryConfig;
        this.taskStateSnapshotsByCheckpointID = new TreeMap<Long, TaskStateSnapshot>();
        this.disposed = false;
    }

    public void storeLocalState(long checkpointId, @Nullable TaskStateSnapshot localState) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        this.taskStateSnapshotsByCheckpointID.put(checkpointId, localState);
    }

    @Nullable
    public TaskStateSnapshot retrieveLocalState(long checkpointID) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        return (TaskStateSnapshot)this.taskStateSnapshotsByCheckpointID.get(checkpointID);
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            for (TaskStateSnapshot stateSnapshot : this.taskStateSnapshotsByCheckpointID.values()) {
                try {
                    stateSnapshot.discardState();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.taskStateSnapshotsByCheckpointID.clear();
        }
    }

    @Nonnull
    public LocalRecoveryConfig getLocalRecoveryConfig() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        return (LocalRecoveryConfig)Preconditions.checkNotNull((Object)this.localRecoveryConfig);
    }

    public void confirmCheckpoint(long confirmedCheckpointId) {
        Map.Entry<Long, TaskStateSnapshot> entry;
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        Iterator<Map.Entry<Long, TaskStateSnapshot>> iterator = this.taskStateSnapshotsByCheckpointID.entrySet().iterator();
        while (iterator.hasNext() && (entry = iterator.next()).getKey() < confirmedCheckpointId) {
            iterator.remove();
            try {
                entry.getValue().discardState();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void abortCheckpoint(long abortedCheckpointId) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        Iterator<Map.Entry<Long, TaskStateSnapshot>> iterator = this.taskStateSnapshotsByCheckpointID.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TaskStateSnapshot> entry = iterator.next();
            if (entry.getKey() == abortedCheckpointId) {
                iterator.remove();
                try {
                    entry.getValue().discardState();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (entry.getKey() <= abortedCheckpointId) continue;
            break;
        }
    }

    public void pruneMatchingCheckpoints(LongPredicate matcher) {
        this.taskStateSnapshotsByCheckpointID.keySet().removeIf(matcher::test);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public SortedMap<Long, TaskStateSnapshot> getTaskStateSnapshotsByCheckpointID() {
        return this.taskStateSnapshotsByCheckpointID;
    }
}

