/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.state.TaskExecutorChannelStateExecutorFactoryManager;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TaskExecutorChannelStateExecutorFactoryManagerTest {
    @Test
    void testReuseFactory() {
        TaskExecutorChannelStateExecutorFactoryManager manager = new TaskExecutorChannelStateExecutorFactoryManager();
        JobID jobID = new JobID();
        ChannelStateWriteRequestExecutorFactory factory = manager.getOrCreateExecutorFactory(jobID);
        ((ObjectAssert)Assertions.assertThat((Object)manager.getOrCreateExecutorFactory(jobID)).as("Same job should share the executor factory.", new Object[0])).isSameAs((Object)factory);
        ((ObjectAssert)Assertions.assertThat((Object)manager.getOrCreateExecutorFactory(new JobID())).as("Different jobs cannot share executor factory.", new Object[0])).isNotSameAs((Object)factory);
        manager.shutdown();
    }

    @Test
    void testReleaseForJob() {
        TaskExecutorChannelStateExecutorFactoryManager manager = new TaskExecutorChannelStateExecutorFactoryManager();
        JobID jobID = new JobID();
        Assertions.assertThat((Object)manager.getFactoryByJobId(jobID)).isNull();
        manager.getOrCreateExecutorFactory(jobID);
        Assertions.assertThat((Object)manager.getFactoryByJobId(jobID)).isNotNull();
        manager.releaseResourcesForJob(jobID);
        Assertions.assertThat((Object)manager.getFactoryByJobId(jobID)).isNull();
        manager.shutdown();
    }

    @Test
    void testShutdown() {
        TaskExecutorChannelStateExecutorFactoryManager manager = new TaskExecutorChannelStateExecutorFactoryManager();
        JobID jobID = new JobID();
        manager.getOrCreateExecutorFactory(jobID);
        manager.shutdown();
        Assertions.assertThatThrownBy(() -> manager.getOrCreateExecutorFactory(jobID)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> manager.getOrCreateExecutorFactory(new JobID())).isInstanceOf(IllegalStateException.class);
    }
}

