/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.e2e;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.DefaultSchedulerBuilder;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkBase;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkUtils;

public class SchedulerEndToEndBenchmarkBase
extends SchedulerBenchmarkBase {
    ComponentMainThreadExecutor mainThreadExecutor;
    JobConfiguration jobConfiguration;
    JobGraph jobGraph;
    PhysicalSlotProvider physicalSlotProvider;
    SlotPool slotPool;

    public void setup(JobConfiguration jobConfiguration) throws Exception {
        super.setup();
        this.jobConfiguration = jobConfiguration;
        this.mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forSingleThreadExecutor(this.scheduledExecutorService);
        List<JobVertex> jobVertices = SchedulerBenchmarkUtils.createDefaultJobVertices(jobConfiguration);
        this.jobGraph = SchedulerBenchmarkUtils.createJobGraph(jobVertices, jobConfiguration);
        this.slotPool = new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.mainThreadExecutor);
        LocationPreferenceSlotSelectionStrategy slotSelectionStrategy = jobConfiguration.isEvenlySpreadOutSlots() ? LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut() : LocationPreferenceSlotSelectionStrategy.createDefault();
        this.physicalSlotProvider = SchedulerEndToEndBenchmarkBase.createPhysicalSlotProvider((SlotSelectionStrategy)slotSelectionStrategy, this.slotPool);
    }

    private static PhysicalSlotProvider createPhysicalSlotProvider(SlotSelectionStrategy slotSelectionStrategy, SlotPool slotPool) {
        return new PhysicalSlotProviderImpl(slotSelectionStrategy, slotPool);
    }

    DefaultScheduler createScheduler(JobGraph jobGraph, PhysicalSlotProvider physicalSlotProvider, ComponentMainThreadExecutor mainThreadExecutor, ScheduledExecutorService executorService) throws Exception {
        DefaultSchedulerBuilder schedulerBuilder = new DefaultSchedulerBuilder(jobGraph, mainThreadExecutor, executorService).setExecutionSlotAllocatorFactory((ExecutionSlotAllocatorFactory)SchedulerTestingUtils.newSlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider));
        if (jobGraph.getJobType() == JobType.BATCH) {
            return SchedulerBenchmarkUtils.createAdaptiveBatchScheduler(schedulerBuilder, this.jobConfiguration);
        }
        return schedulerBuilder.build();
    }
}

