/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.e2e;

import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.failover.flip1.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.DefaultSchedulerBuilder;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkUtils;
import org.apache.flink.runtime.scheduler.benchmark.e2e.SchedulerEndToEndBenchmarkBase;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class HandleGlobalFailureAndRestartAllTasksBenchmark
extends SchedulerEndToEndBenchmarkBase {
    private static final int SLOTS_PER_TASK_EXECUTOR = 4;
    private DefaultScheduler scheduler;
    private ManuallyTriggeredScheduledExecutor taskRestartExecutor;

    @Override
    public void setup(JobConfiguration jobConfiguration) throws Exception {
        this.taskRestartExecutor = new ManuallyTriggeredScheduledExecutor();
        this.scheduledExecutorService = new DirectScheduledExecutorService();
        super.setup(jobConfiguration);
        this.scheduler = this.createScheduler(this.jobGraph, this.physicalSlotProvider, this.mainThreadExecutor, this.scheduledExecutorService, (ScheduledExecutor)this.taskRestartExecutor, new FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory(1, 1L).create());
        this.scheduler.startScheduling();
        this.offerSlots();
    }

    public void handleGlobalFailureAndRestartAllTasks() throws Exception {
        this.scheduler.handleGlobalFailure((Throwable)new RuntimeException("For test."));
        ExecutionGraphTestUtils.completeCancellingForAllVertices(this.scheduler.getExecutionGraph());
        this.taskRestartExecutor.triggerScheduledTasks();
    }

    private DefaultScheduler createScheduler(JobGraph jobGraph, PhysicalSlotProvider physicalSlotProvider, ComponentMainThreadExecutor mainThreadExecutor, ScheduledExecutorService executorService, ScheduledExecutor taskRestartExecutor, RestartBackoffTimeStrategy restartBackoffTimeStrategy) throws Exception {
        DefaultSchedulerBuilder schedulerBuilder = new DefaultSchedulerBuilder(jobGraph, mainThreadExecutor, executorService, executorService, taskRestartExecutor).setExecutionSlotAllocatorFactory((ExecutionSlotAllocatorFactory)SchedulerTestingUtils.newSlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider)).setRestartBackoffTimeStrategy(restartBackoffTimeStrategy);
        if (jobGraph.getJobType() == JobType.BATCH) {
            return SchedulerBenchmarkUtils.createAdaptiveBatchScheduler(schedulerBuilder, this.jobConfiguration);
        }
        return schedulerBuilder.build();
    }

    private void offerSlots() {
        int numberSlots = StreamSupport.stream(this.jobGraph.getVertices().spliterator(), false).mapToInt(JobVertex::getParallelism).sum();
        int i = 0;
        while ((double)i < Math.ceil((double)numberSlots / 4.0)) {
            SlotPoolUtils.tryOfferSlots(this.slotPool, this.mainThreadExecutor, Collections.nCopies(4, ResourceProfile.ANY));
            ++i;
        }
    }
}

