/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.scheduler.DefaultSchedulerComponents;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSchedulerComponentsFactoryTest
extends TestLogger {
    @Test
    public void testCreatingPipelinedSchedulingStrategyFactory() {
        DefaultSchedulerComponents components = DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(new Configuration());
        Assert.assertThat((Object)components.getSchedulingStrategyFactory(), (Matcher)Matchers.instanceOf(PipelinedRegionSchedulingStrategy.Factory.class));
        Assert.assertThat((Object)components.getAllocatorFactory(), (Matcher)Matchers.instanceOf(SlotSharingExecutionSlotAllocatorFactory.class));
    }

    @Test
    public void testCreatingPipelinedRegionSchedulingStrategyFactoryByDefault() {
        DefaultSchedulerComponents components = DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(new Configuration());
        Assert.assertThat((Object)components.getSchedulingStrategyFactory(), (Matcher)Matchers.instanceOf(PipelinedRegionSchedulingStrategy.Factory.class));
    }

    @Test
    public void testCreatingPipelinedRegionSchedulingStrategyFactoryWithApproximateLocalRecovery() {
        Configuration configuration = new Configuration();
        try {
            DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(configuration, true, JobType.STREAMING);
            Assert.fail((String)"expected failure");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)"Approximate local recovery can not be used together with PipelinedRegionScheduler for now"));
        }
    }

    private static DefaultSchedulerComponents createSchedulerComponents(Configuration configuration) {
        return DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(configuration, false, JobType.BATCH);
    }

    private static DefaultSchedulerComponents createSchedulerComponents(Configuration configuration, boolean iApproximateLocalRecoveryEnabled, JobType jobType) {
        return DefaultSchedulerComponents.createSchedulerComponents((JobType)jobType, (boolean)iApproximateLocalRecoveryEnabled, (Configuration)configuration, (SlotPool)SlotPoolUtils.createDeclarativeSlotPoolBridge(), (Time)Time.milliseconds((long)10L));
    }
}

