/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.runtime.rest.handler.taskmanager.TestingChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledHeapByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelProgressivePromise;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.util.Attribute;
import org.apache.flink.shaded.netty4.io.netty.util.AttributeKey;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.ImmediateEventExecutor;
import org.apache.flink.util.Preconditions;

class TestingChannelHandlerContext
implements ChannelHandlerContext {
    private final File outputFile;
    private final ChannelPipeline pipeline = new TestingChannelPipeline();
    private HttpResponse httpResponse;
    private byte[] responseData;

    TestingChannelHandlerContext(File outputFile) {
        this.outputFile = (File)Preconditions.checkNotNull((Object)outputFile);
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        block18: {
            if (msg instanceof DefaultFileRegion) {
                DefaultFileRegion defaultFileRegion = (DefaultFileRegion)msg;
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);){
                    fileOutputStream.getChannel();
                    defaultFileRegion.transferTo((WritableByteChannel)fileOutputStream.getChannel(), 0L);
                    break block18;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            if (msg instanceof HttpResponse) {
                this.httpResponse = (HttpResponse)msg;
            } else if (msg instanceof UnpooledHeapByteBuf) {
                this.responseData = ((UnpooledHeapByteBuf)msg).array();
            }
        }
        return new DefaultChannelPromise((Channel)new EmbeddedChannel()).setSuccess();
    }

    public EventExecutor executor() {
        return ImmediateEventExecutor.INSTANCE;
    }

    public ChannelFuture write(Object msg) {
        return this.write(msg, null);
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        ChannelFuture channelFuture = this.write(msg, promise);
        this.flush();
        return channelFuture;
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, null);
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public Channel channel() {
        return null;
    }

    public String name() {
        return null;
    }

    public ChannelHandler handler() {
        return null;
    }

    public boolean isRemoved() {
        return false;
    }

    public ChannelHandlerContext fireChannelRegistered() {
        return null;
    }

    public ChannelHandlerContext fireChannelUnregistered() {
        return null;
    }

    public ChannelHandlerContext fireChannelActive() {
        return null;
    }

    public ChannelHandlerContext fireChannelInactive() {
        return null;
    }

    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        return null;
    }

    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        return null;
    }

    public ChannelHandlerContext fireChannelRead(Object msg) {
        return null;
    }

    public ChannelHandlerContext fireChannelReadComplete() {
        return null;
    }

    public ChannelHandlerContext fireChannelWritabilityChanged() {
        return null;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return null;
    }

    public ChannelFuture disconnect() {
        return null;
    }

    public ChannelFuture close() {
        return null;
    }

    public ChannelFuture deregister() {
        return null;
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return null;
    }

    public ChannelFuture close(ChannelPromise promise) {
        return null;
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return null;
    }

    public ChannelHandlerContext read() {
        return null;
    }

    public ChannelHandlerContext flush() {
        return null;
    }

    public ByteBufAllocator alloc() {
        return null;
    }

    public ChannelPromise newPromise() {
        return null;
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return null;
    }

    public ChannelFuture newSucceededFuture() {
        return null;
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return null;
    }

    public ChannelPromise voidPromise() {
        return null;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return null;
    }

    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        return false;
    }
}

