/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.taskmanager.TestUntypedMessageHeaders;
import org.apache.flink.runtime.rest.handler.taskmanager.TestingChannelHandlerContext;
import org.apache.flink.runtime.rest.handler.taskmanager.TestingTaskManagerStdoutFileHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerFileMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FlinkException;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TaskManagerStdoutFileHandlerTest {
    private static final ResourceID EXPECTED_TASK_MANAGER_ID = ResourceID.generate();
    private static final DefaultFullHttpRequest HTTP_REQUEST = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/foobar");
    @TempDir
    private static File temporaryFolder;
    private static BlobServer blobServer;
    private static HandlerRequest<EmptyRequestBody> handlerRequest;

    TaskManagerStdoutFileHandlerTest() {
    }

    @BeforeAll
    static void setup() throws IOException, HandlerRequestException {
        Configuration configuration = new Configuration();
        blobServer = new BlobServer(configuration, temporaryFolder, (BlobStore)new VoidBlobStore());
        handlerRequest = HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerFileMessageParameters(), Collections.singletonMap("taskmanagerid", EXPECTED_TASK_MANAGER_ID.getResourceIdString()), Collections.emptyMap(), Collections.emptyList());
    }

    @AfterAll
    static void teardown() throws IOException {
        if (blobServer != null) {
            blobServer.close();
            blobServer = null;
        }
    }

    @Test
    void testStdoutFileHandlerHandleFileNotFoundException() throws Exception {
        CompletableFuture handleFuture;
        TestingChannelHandlerContext testingContext;
        Time cacheEntryDuration = Time.milliseconds((long)1000L);
        try (TestingTaskManagerStdoutFileHandler testingTaskManagerStdoutFileHandler = this.createTestTaskManagerStdoutFileHandler(cacheEntryDuration, new FileNotFoundException("file not found"));){
            File outputFile = TempDirUtils.newFile((Path)temporaryFolder.toPath());
            testingContext = new TestingChannelHandlerContext(outputFile);
            handleFuture = testingTaskManagerStdoutFileHandler.respondToRequest(testingContext, (HttpRequest)HTTP_REQUEST, handlerRequest, null);
        }
        Assertions.assertThat((CompletableFuture)handleFuture).isCompleted();
        ((ObjectAssert)Assertions.assertThat((Object)testingContext.getHttpResponse()).isNotNull()).satisfies(new ThrowingConsumer[]{httpResponse -> {
            AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)httpResponse.status()).isEqualTo((Object)HttpResponseStatus.OK);
        }});
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])testingContext.getResponseData()).isNotNull()).satisfies(new ThrowingConsumer[]{data -> Assertions.assertThat((String)new String((byte[])data, "UTF-8")).isEqualTo("The file STDOUT does not exist on the TaskExecutor. \nIf you are using kubernetes mode, please use \"kubectl logs <pod-name>\" to get stdout content.")});
    }

    @Test
    void testStdoutFileHandlerHandleOtherException() throws Exception {
        CompletableFuture handleFuture;
        TestingChannelHandlerContext testingContext;
        Time cacheEntryDuration = Time.milliseconds((long)1000L);
        try (TestingTaskManagerStdoutFileHandler testingTaskManagerStdoutFileHandler = this.createTestTaskManagerStdoutFileHandler(cacheEntryDuration, (Exception)((Object)new FlinkException("excepted exception")));){
            File outputFile = TempDirUtils.newFile((Path)temporaryFolder.toPath());
            testingContext = new TestingChannelHandlerContext(outputFile);
            handleFuture = testingTaskManagerStdoutFileHandler.respondToRequest(testingContext, (HttpRequest)HTTP_REQUEST, handlerRequest, null);
        }
        Assertions.assertThat((CompletableFuture)handleFuture).isCompletedExceptionally();
        Assertions.assertThat((Object)testingContext.getHttpResponse()).isNull();
        Assertions.assertThat((byte[])testingContext.getResponseData()).isNull();
    }

    private TestingTaskManagerStdoutFileHandler createTestTaskManagerStdoutFileHandler(Time cacheEntryDuration, Exception exceptionForRequestFileUpload) {
        TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
        return new TestingTaskManagerStdoutFileHandler((GatewayRetriever<? extends RestfulGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(null)), TestingUtils.infiniteTime(), Collections.emptyMap(), new TestUntypedMessageHeaders(), (GatewayRetriever<ResourceManagerGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(resourceManagerGateway)), (TransientBlobService)blobServer, cacheEntryDuration, exceptionForRequestFileUpload);
    }
}

